/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.craft;

import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.craft.CraftingResult;
import fr.minepiece.common.craft.IMinePieceCraftingInventory;
import fr.minepiece.common.craft.IMinePieceCraftingRecipe;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;

public abstract class AbstractShapedMinePieceRecipe
extends ShapedOreRecipe
implements IMinePieceCraftingRecipe {
    protected final ItemStack result;
    protected final int levelRequired;
    protected final int xpReward;
    protected final MinePieceJobs requiredJob;
    protected final NonNullList<Ingredient> ingredients;
    protected final int width;
    protected final int height;

    public AbstractShapedMinePieceRecipe(ResourceLocation group, ItemStack result, NonNullList<Ingredient> ingredients, int width, int height, int levelRequired, int xpReward, MinePieceJobs requiredJob) {
        super(group, result, AbstractShapedMinePieceRecipe.createPrimer(ingredients, width, height));
        this.result = result;
        this.ingredients = ingredients;
        this.width = width;
        this.height = height;
        this.levelRequired = levelRequired;
        this.xpReward = xpReward;
        this.requiredJob = requiredJob;
    }

    private static CraftingHelper.ShapedPrimer createPrimer(NonNullList<Ingredient> ingredients, int width, int height) {
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = width;
        primer.height = height;
        primer.mirrored = false;
        primer.input = ingredients;
        return primer;
    }

    @Override
    public boolean matches(IMinePieceCraftingInventory inventory, World world) {
        if (inventory.getWidth() < this.width || inventory.getHeight() < this.height) {
            return false;
        }
        return this.checkMatch(inventory);
    }

    protected boolean checkMatch(IMinePieceCraftingInventory inventory) {
        int minMultiplier = Integer.MAX_VALUE;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int patternIndex = y * this.width + x;
                int inventoryIndex = y * inventory.getWidth() + x;
                Ingredient ingredient = (Ingredient)this.ingredients.get(patternIndex);
                ItemStack slotStack = inventory.func_70301_a(inventoryIndex);
                if (ingredient == Ingredient.field_193370_a) continue;
                if (!ingredient.apply(slotStack)) {
                    return false;
                }
                if (!slotStack.func_190926_b()) {
                    int multiplier = slotStack.func_190916_E();
                    minMultiplier = Math.min(minMultiplier, multiplier);
                    continue;
                }
                return false;
            }
        }
        return minMultiplier > 0 && minMultiplier != Integer.MAX_VALUE;
    }

    @Override
    public CraftingResult getCraftingResult(IMinePieceCraftingInventory inventory) {
        int multiplier = this.getMultiplier(inventory);
        if (multiplier <= 0) {
            return new CraftingResult(ItemStack.field_190927_a, 0, new ArrayList<CraftingResult.ItemPosition>());
        }
        ArrayList<CraftingResult.ItemPosition> consumedItems = new ArrayList<CraftingResult.ItemPosition>();
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int patternIndex = y * this.width + x;
                int inventoryIndex = y * inventory.getWidth() + x;
                Ingredient ingredient = (Ingredient)this.ingredients.get(patternIndex);
                ItemStack slotStack = inventory.func_70301_a(inventoryIndex);
                if (ingredient == Ingredient.field_193370_a || !ingredient.apply(slotStack)) continue;
                consumedItems.add(new CraftingResult.ItemPosition(inventoryIndex, multiplier));
            }
        }
        ItemStack craftedResult = this.result.func_77946_l();
        craftedResult.func_190920_e(craftedResult.func_190916_E() * multiplier);
        return new CraftingResult(craftedResult, multiplier, consumedItems);
    }

    protected int getMultiplier(IMinePieceCraftingInventory inventory) {
        int minMultiplier = Integer.MAX_VALUE;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                int patternIndex = y * this.width + x;
                int inventoryIndex = y * inventory.getWidth() + x;
                Ingredient ingredient = (Ingredient)this.ingredients.get(patternIndex);
                ItemStack slotStack = inventory.func_70301_a(inventoryIndex);
                if (ingredient == Ingredient.field_193370_a) continue;
                if (ingredient.apply(slotStack) && !slotStack.func_190926_b()) {
                    minMultiplier = Math.min(minMultiplier, slotStack.func_190916_E());
                    continue;
                }
                return 0;
            }
        }
        return minMultiplier == Integer.MAX_VALUE ? 0 : minMultiplier;
    }

    @Override
    public int getLevelRequired() {
        return this.levelRequired;
    }

    @Override
    public int getBaseXpReward() {
        return this.xpReward;
    }

    @Override
    public MinePieceJobs getRequiredJob() {
        return this.requiredJob;
    }

    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }
}

