/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.capability.thirst;

import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.capability.temperature.ITemperature;
import fr.minepiece.common.capability.temperature.TemperatureProvider;
import fr.minepiece.common.capability.thirst.IThirst;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.ThirstSyncPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DefaultThirst
implements IThirst {
    private float thirstLevel = 20.0f;
    private float thirstSaturation = 5.0f;
    private float exhaustion = 0.0f;
    private static final float MAX_EXHAUSTION = 4.0f;
    public static final DamageSource THIRST = new DamageSource("thirst").func_76348_h();

    @Override
    public float getThirstLevel() {
        return this.thirstLevel;
    }

    @Override
    public void setThirstLevel(float level) {
        this.thirstLevel = Math.min(20.0f, Math.max(0.0f, level));
    }

    @Override
    public float getThirstSaturation() {
        return this.thirstSaturation;
    }

    @Override
    public void setThirstSaturation(float saturation) {
        this.thirstSaturation = Math.max(0.0f, saturation);
    }

    @Override
    public void drink(float water, float saturation) {
        this.thirstLevel = Math.min(this.thirstLevel + water, 20.0f);
        this.thirstSaturation = Math.min(this.thirstSaturation + saturation, this.thirstLevel);
    }

    @Override
    public void addExhaustion(EntityPlayerMP player, float amount) {
        if (amount <= 0.0f) {
            return;
        }
        this.exhaustion += amount * 0.6f;
        while (this.exhaustion >= 4.0f) {
            this.exhaustion -= 4.0f;
            if (this.thirstSaturation > 0.0f) {
                this.thirstSaturation = Math.max(0.0f, this.thirstSaturation - 1.0f);
                continue;
            }
            this.thirstLevel = Math.max(0.0f, this.thirstLevel - 1.0f);
        }
    }

    @Override
    public float getExhaustion() {
        return this.exhaustion;
    }

    @Override
    public void setExhaustion(float exhaustion) {
        this.exhaustion = exhaustion;
    }

    @Override
    public void clientSync(EntityPlayerMP player) {
        ModPackets.NETWORK.sendTo((IMessage)new ThirstSyncPacket(this), player);
    }

    public static void syncStats(IThirst thirstOrig, IThirst thirstNew) {
        thirstNew.setThirstLevel(thirstOrig.getThirstLevel());
        thirstNew.setThirstSaturation(thirstOrig.getThirstSaturation());
        thirstNew.setExhaustion(thirstOrig.getExhaustion());
    }

    private float getRacialResistance(EntityPlayer player) {
        float resistance = 1.0f;
        IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (data != null) {
            MinePieceRaces race = data.getRace();
            int level = data.getLevel();
            if (race == MinePieceRaces.FISHMAN) {
                resistance = 0.5f;
            } else if (race == MinePieceRaces.CYBORG) {
                resistance = 0.8f;
            }
            resistance *= 1.0f - (float)level * 0.005f;
        }
        return Math.max(0.25f, resistance);
    }

    public void update(EntityPlayer player) {
        ITemperature temp;
        if (player.field_70170_p.field_72995_K || player.func_184812_l_()) {
            this.thirstLevel = 20.0f;
            this.thirstSaturation = 5.0f;
            return;
        }
        float racialResistance = this.getRacialResistance(player);
        float biomeModifier = 1.0f;
        Biome biome = player.field_70170_p.func_180494_b(player.func_180425_c());
        if (biome.func_180626_a(player.func_180425_c()) > 0.9f) {
            biomeModifier = 1.5f;
        } else if (biome.func_180626_a(player.func_180425_c()) > 0.6f) {
            biomeModifier = 1.2f;
        }
        if (player.getCapability(TemperatureProvider.TEMPERATURE_CAPABILITY, null) != null && (temp = (ITemperature)player.getCapability(TemperatureProvider.TEMPERATURE_CAPABILITY, null)).getTemperature() > 38.0) {
            biomeModifier *= 1.0f + ((float)temp.getTemperature() - 38.0f) / 10.0f;
        }
        float finalModifier = biomeModifier * racialResistance;
        if (player.func_70051_ag()) {
            this.addExhaustion((EntityPlayerMP)player, 0.008f * finalModifier);
        } else if (player.func_70090_H() && player.field_70181_x < 0.0) {
            this.addExhaustion((EntityPlayerMP)player, 0.005f * finalModifier);
        } else if (player.field_70143_R > 0.0f) {
            this.addExhaustion((EntityPlayerMP)player, 0.004f * finalModifier);
        } else if (player.field_82175_bq) {
            this.addExhaustion((EntityPlayerMP)player, 0.004f * finalModifier);
        } else {
            this.addExhaustion((EntityPlayerMP)player, 0.002f * finalModifier);
        }
        if (this.thirstLevel <= 0.0f) {
            if (player.field_70170_p.func_72820_D() % 60L == 0L) {
                player.func_70097_a(DamageSource.field_76366_f, 1.5f);
                player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 240, 2));
                player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 240, 2));
                player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 240, 1));
            }
        } else if (this.thirstLevel <= 3.0f) {
            if (player.field_70170_p.func_72820_D() % 100L == 0L) {
                player.func_70097_a(DamageSource.field_76366_f, 1.0f);
                player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 220, 1));
                player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 220, 1));
            }
        } else if (this.thirstLevel <= 6.0f) {
            if (player.field_70170_p.func_72820_D() % 200L == 0L) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 200, 0));
                player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 0));
            }
        } else if (this.thirstLevel <= 10.0f && player.field_70170_p.func_72820_D() % 300L == 0L) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 160, 0));
        }
    }
}

