/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.capability.temperature;

import net.minecraft.util.ResourceLocation;

public enum TemperatureState {
    HYPOTHERMIA_DEATH("temperature_hypo_4", 0, 28.0),
    HYPOTHERMIA_SEVERE("temperature_hypo_3", 1, 30.0),
    HYPOTHERMIA_MODERATE("temperature_hypo_2", 2, 32.0),
    HYPOTHERMIA_MILD("temperature_hypo_1", 3, 34.0),
    NORMAL("temperature_normal", 4, 39.0),
    HYPERTHERMIA_MILD("temperature_hyper_1", 5, 40.0),
    HYPERTHERMIA_MODERATE("temperature_hyper_2", 6, 41.5),
    HYPERTHERMIA_SEVERE("temperature_hyper_3", 7, 43.0),
    HYPERTHERMIA_DEATH("temperature_hyper_4", 8, Double.MAX_VALUE);

    private final String iconName;
    private final int uiIndex;
    private final double maxTemperature;

    private TemperatureState(String iconName, int uiIndex, double maxTemperature) {
        this.iconName = iconName;
        this.uiIndex = uiIndex;
        this.maxTemperature = maxTemperature;
    }

    public ResourceLocation getIconResource() {
        return new ResourceLocation("minepiece", "textures/gui/temperature/" + this.iconName + ".png");
    }

    public int getUIIndex() {
        return this.uiIndex;
    }

    public double getMaxTemperature() {
        return this.maxTemperature;
    }

    public static TemperatureState getStateFromTemperature(double temperature) {
        for (TemperatureState state : TemperatureState.values()) {
            if (!(temperature <= state.getMaxTemperature())) continue;
            return state;
        }
        return HYPERTHERMIA_DEATH;
    }
}

