/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.capability.temperature;

import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class RaceTemperatureModifiers {
    private static final double GIANT_COLD_RESISTANCE = 1.5;
    private static final double MINKS_COLD_RESISTANCE = 1.3;
    private static final double FISHMAN_COLD_RESISTANCE = 0.7;
    private static final double CYBORG_HEAT_RESISTANCE = 0.8;
    private static final double RESISTANCE_PER_LEVEL = 0.01;
    private static final Map<MinePieceRaces, Double> RACE_BASE_TEMPERATURES = new HashMap<MinePieceRaces, Double>();
    private static final double DEFAULT_HUMAN_BASE_TEMP = 37.0;
    private static final double DEFAULT_GIANT_BASE_TEMP = 37.2;
    private static final double DEFAULT_MINKS_BASE_TEMP = 38.0;
    private static final double DEFAULT_FISHMAN_BASE_TEMP = 35.5;
    private static final double DEFAULT_CYBORG_BASE_TEMP = 36.0;

    public static void setRaceBaseTemperature(MinePieceRaces race, double temperature) {
        RACE_BASE_TEMPERATURES.put(race, temperature);
    }

    public static double getRaceBaseTemperature(MinePieceRaces race) {
        return RACE_BASE_TEMPERATURES.getOrDefault((Object)race, 37.0);
    }

    public static double getColdResistanceModifier(EntityPlayer player) {
        IMinePieceData playerData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (playerData == null) {
            return 1.0;
        }
        MinePieceRaces race = playerData.getRace();
        int level = playerData.getLevel();
        double baseResistance = 1.0;
        if (race == MinePieceRaces.GIANT) {
            baseResistance = 1.5;
        } else if (race == MinePieceRaces.MINKS) {
            baseResistance = 1.3;
        } else if (race == MinePieceRaces.FISHMAN) {
            baseResistance = 0.7;
        }
        double levelBonus = 1.0 + (double)level * 0.01;
        return baseResistance * levelBonus;
    }

    public static double getHeatResistanceModifier(EntityPlayer player) {
        IMinePieceData playerData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (playerData == null) {
            return 1.0;
        }
        MinePieceRaces race = playerData.getRace();
        int level = playerData.getLevel();
        double baseResistance = 1.0;
        if (race == MinePieceRaces.CYBORG) {
            baseResistance = 0.8;
        }
        double levelBonus = 1.0 + (double)level * 0.01;
        return baseResistance * levelBonus;
    }

    public static double getTemperatureChangeRate(EntityPlayer player, double environmentTemp, double currentTemp) {
        double changeRate;
        if (environmentTemp < 20.0) {
            double coldMod = RaceTemperatureModifiers.getColdResistanceModifier(player);
            changeRate = 1.0 / coldMod;
        } else if (environmentTemp > 35.0) {
            double heatMod = RaceTemperatureModifiers.getHeatResistanceModifier(player);
            changeRate = 1.0 / heatMod;
        } else {
            changeRate = 1.0;
        }
        return changeRate;
    }

    public static double getBaseTemperatureForRace(EntityPlayer player) {
        IMinePieceData playerData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (playerData == null) {
            return RaceTemperatureModifiers.getRaceBaseTemperature(MinePieceRaces.HUMAN);
        }
        MinePieceRaces race = playerData.getRace();
        double randomVariation = Math.random() - 0.5;
        return RaceTemperatureModifiers.getRaceBaseTemperature(race) + randomVariation;
    }

    static {
        RACE_BASE_TEMPERATURES.put(MinePieceRaces.HUMAN, 37.0);
        RACE_BASE_TEMPERATURES.put(MinePieceRaces.GIANT, 37.2);
        RACE_BASE_TEMPERATURES.put(MinePieceRaces.MINKS, 38.0);
        RACE_BASE_TEMPERATURES.put(MinePieceRaces.FISHMAN, 35.5);
        RACE_BASE_TEMPERATURES.put(MinePieceRaces.CYBORG, 36.0);
    }
}

