/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.capability.temperature;

import fr.minepiece.common.capability.temperature.ITemperature;
import fr.minepiece.common.capability.temperature.RaceTemperatureModifiers;
import fr.minepiece.common.capability.temperature.TemperatureState;
import fr.minepiece.common.init.ModPotions;
import fr.minepiece.common.utils.BiomeTemperatures;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class DefaultTemperature
implements ITemperature {
    private static final String NBT_TEMPERATURE = "Temperature";
    private static final String NBT_BASE_TEMPERATURE = "BaseTemperature";
    private static final double MIN_TEMPERATURE = -10.0;
    private static final double MAX_TEMPERATURE = 45.0;
    private static int UPDATE_INTERVAL = 800;
    private static double DEFAULT_TEMP_CHANGE = 0.1;
    private static final double COLD_THRESHOLD = 8.0;
    private static final double HEAT_THRESHOLD = 32.0;
    private double temperature;
    private double baseTemperature;
    private long lastUpdate;

    public DefaultTemperature() {
        this.temperature = this.baseTemperature = 37.0;
        this.lastUpdate = 0L;
    }

    public static void setUpdateInterval(int ticks) {
        UPDATE_INTERVAL = ticks;
    }

    public static int getUpdateInterval() {
        return UPDATE_INTERVAL;
    }

    public static void setDefaultTempChange(double change) {
        DEFAULT_TEMP_CHANGE = change;
    }

    public static double getDefaultTempChange() {
        return DEFAULT_TEMP_CHANGE;
    }

    @Override
    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(double temperature) {
        this.temperature = temperature;
    }

    @Override
    public double getBaseTemperature() {
        return this.baseTemperature;
    }

    @Override
    public void setBaseTemperature(double baseTemperature) {
        this.baseTemperature = baseTemperature;
    }

    @Override
    public TemperatureState getCurrentState() {
        return TemperatureState.getStateFromTemperature(this.temperature);
    }

    @Override
    public void applyEffects(EntityPlayer player) {
        StringBuilder message = new StringBuilder();
        TemperatureState state = this.getCurrentState();
        Double temp = this.getTemperature();
        player.func_184589_d(ModPotions.TEMPERATURE_EFFECT);
        switch (state) {
            case HYPOTHERMIA_MILD: 
            case HYPERTHERMIA_MILD: {
                player.func_70690_d(new PotionEffect(ModPotions.TEMPERATURE_EFFECT, 220, 0));
                message.append(TextFormatting.GREEN).append("Vous ressentez les effets de la temp\u00e9rature, ").append(temp).append("\u00b0C");
                break;
            }
            case HYPOTHERMIA_MODERATE: 
            case HYPERTHERMIA_MODERATE: {
                player.func_70690_d(new PotionEffect(ModPotions.TEMPERATURE_EFFECT, 220, 1));
                message.append(TextFormatting.GREEN).append("Vous ressentez encore plus les effets de la temp\u00e9rature, attention ! ").append(temp).append("\u00b0C");
                break;
            }
            case HYPOTHERMIA_SEVERE: 
            case HYPERTHERMIA_SEVERE: {
                player.func_70690_d(new PotionEffect(ModPotions.TEMPERATURE_EFFECT, 220, 2));
                message.append(TextFormatting.GREEN).append("La temp\u00e9rature commence \u00e0 devenir critique, vous \u00eates en danger, ").append(temp).append("\u00b0C");
                break;
            }
            case HYPOTHERMIA_DEATH: 
            case HYPERTHERMIA_DEATH: {
                player.func_70690_d(new PotionEffect(ModPotions.TEMPERATURE_EFFECT, 220, 3));
                message.append(TextFormatting.GREEN).append("C'est la fin des haricots, ").append(temp).append("\u00b0C");
            }
        }
    }

    @Override
    public void updateTemperature(EntityPlayer player) {
        double raceModifier;
        if (player.func_184812_l_()) {
            this.temperature = this.baseTemperature;
            return;
        }
        long currentTime = player.field_70170_p.func_82737_E();
        if (currentTime - this.lastUpdate < (long)UPDATE_INTERVAL) {
            return;
        }
        this.lastUpdate = currentTime;
        BlockPos playerPos = player.func_180425_c();
        double environmentTemp = BiomeTemperatures.getFinalEnvironmentTemperature(player.field_70170_p, playerPos, player.field_70170_p.func_72820_D());
        double tempChange = 0.0;
        boolean holdingTorch = BiomeTemperatures.isHoldingTorch(player);
        if (environmentTemp < 8.0) {
            tempChange = -DEFAULT_TEMP_CHANGE;
            if (holdingTorch && this.temperature < this.baseTemperature) {
                tempChange = DEFAULT_TEMP_CHANGE;
            } else {
                raceModifier = RaceTemperatureModifiers.getTemperatureChangeRate(player, environmentTemp, this.temperature);
                tempChange *= raceModifier;
                tempChange *= BiomeTemperatures.getArmorInsulation(player);
            }
        } else if (environmentTemp > 32.0) {
            tempChange = DEFAULT_TEMP_CHANGE;
            raceModifier = RaceTemperatureModifiers.getTemperatureChangeRate(player, environmentTemp, this.temperature);
            tempChange *= raceModifier;
            tempChange *= 2.0 - BiomeTemperatures.getArmorInsulation(player);
        } else if (Math.abs(this.temperature - this.baseTemperature) > 0.1) {
            double d = tempChange = this.temperature < this.baseTemperature ? DEFAULT_TEMP_CHANGE : -DEFAULT_TEMP_CHANGE;
            if (holdingTorch && tempChange < 0.0) {
                tempChange = 0.0;
            }
        }
        double waterMultiplier = BiomeTemperatures.getWaterEffect(player.field_70170_p, playerPos);
        if (tempChange < 0.0) {
            tempChange *= waterMultiplier;
        }
        this.temperature += tempChange;
        this.temperature = Math.max(Math.min(this.temperature, 45.0), -10.0);
    }

    @Override
    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74780_a(NBT_TEMPERATURE, this.temperature);
        compound.func_74780_a(NBT_BASE_TEMPERATURE, this.baseTemperature);
    }

    @Override
    public void loadNBTData(NBTTagCompound compound) {
        this.temperature = compound.func_74769_h(NBT_TEMPERATURE);
        this.baseTemperature = compound.func_74769_h(NBT_BASE_TEMPERATURE);
    }

    @Override
    public void copy(ITemperature temperature) {
        this.temperature = temperature.getTemperature();
        this.baseTemperature = temperature.getBaseTemperature();
    }
}

