/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.capability.knockout;

import fr.minepiece.common.capability.knockout.DefaultKOState;
import fr.minepiece.common.capability.knockout.IKOState;
import fr.minepiece.common.capability.knockout.KOStateProvider;
import fr.minepiece.common.capability.knockout.KOStateStorage;
import fr.minepiece.common.handlers.PlayerKOHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class KOCapabilityAttachment {
    private static final ResourceLocation KO_STATE_CAP = new ResourceLocation("minepiece", "ko_state");

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(KO_STATE_CAP, (ICapabilityProvider)new KOStateProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        EntityPlayer original = event.getOriginal();
        EntityPlayer player = event.getEntityPlayer();
        IKOState originalKO = (IKOState)original.getCapability(KOStateStorage.KO_STATE_CAPABILITY, null);
        IKOState newKO = (IKOState)player.getCapability(KOStateStorage.KO_STATE_CAPABILITY, null);
        if (originalKO != null && newKO != null) {
            DefaultKOState.syncStats(originalKO, newKO);
            if (player instanceof EntityPlayerMP) {
                PlayerKOHandler.syncClientKOState((EntityPlayerMP)player, false);
            }
        }
    }
}

