/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.plantable;

import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.blocks.plantable.AbstractFlowerBlock;
import fr.minepiece.common.blocks.plantable.FlowerTileEntity;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.items.jobs.cook.CookToolItem;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class FruitBlock
extends AbstractFlowerBlock {
    private Item foodItem;
    private Item immatureFoodItem;
    private final boolean isImmature;
    private final Block nextStateBlock;
    private final String matureBlockName;
    private final Block cutStateBlock;

    public FruitBlock(String name, int jobXpAmount) {
        super(name, Material.field_151585_k, jobXpAmount, MinePieceJobs.COOK, name.replace("_cut", "_immature"));
        this.isImmature = false;
        this.nextStateBlock = null;
        this.matureBlockName = null;
        this.cutStateBlock = null;
        this.func_149711_c(0.9f);
    }

    public FruitBlock(String name, int jobXpAmount, FruitBlock cutState) {
        super(name, Material.field_151585_k, jobXpAmount, MinePieceJobs.COOK, true, cutState, cutState.getRegistryName().func_110623_a());
        this.isImmature = true;
        this.nextStateBlock = cutState;
        this.matureBlockName = name.replace("_immature", "");
        this.cutStateBlock = null;
        this.func_149711_c(1.0f);
    }

    public FruitBlock(String name, int jobXpAmount, FruitBlock immatureState, Item foodItem) {
        super(name, Material.field_151585_k, jobXpAmount, MinePieceJobs.COOK, true, immatureState, immatureState.getRegistryName().func_110623_a());
        this.isImmature = false;
        this.foodItem = foodItem;
        this.nextStateBlock = this.cutStateBlock = immatureState.nextStateBlock;
        this.matureBlockName = null;
        this.func_149711_c(1.1f);
    }

    @Override
    protected boolean isValidTool(Item tool) {
        return tool instanceof CookToolItem;
    }

    public FruitBlock setFoodItem(Item foodItem) {
        this.foodItem = foodItem;
        return this;
    }

    public FruitBlock setImmatureFoodItem(Item immatureFoodItem) {
        this.immatureFoodItem = immatureFoodItem;
        return this;
    }

    public Item getFoodItem() {
        return this.foodItem;
    }

    public Item getImmatureFoodItem() {
        return this.immatureFoodItem;
    }

    @Override
    protected Item getHarvestDrop() {
        if (this.isImmature && this.immatureFoodItem != null) {
            return this.immatureFoodItem;
        }
        if (this.isImmature) {
            return null;
        }
        return this.foodItem;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (!this.isMature) {
            return false;
        }
        ItemStack heldItem = playerIn.func_184586_b(hand);
        Item tool = heldItem.func_77973_b();
        if (!this.isValidTool(tool)) {
            return false;
        }
        IMinePieceData mpData = (IMinePieceData)playerIn.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (mpData == null || mpData.getJob() != this.requiredJob || !(tool instanceof CookToolItem) || !((CookToolItem)tool).isUsableAtLevel(mpData.getJobLevel())) {
            return false;
        }
        UUID playerUUID = playerIn.func_110124_au();
        if (this.isPlayerHarvesting(playerUUID, pos)) {
            long startTime = this.getHarvestStartTime(playerUUID, pos);
            long currentTime = System.currentTimeMillis();
            if (currentTime - startTime >= 2000L) {
                if (this.isImmature) {
                    this.completeImmatureHarvest(worldIn, pos, state, playerIn, (CookToolItem)tool, mpData);
                } else {
                    this.completeMatureHarvest(worldIn, pos, state, playerIn, (CookToolItem)tool, mpData);
                }
                this.removeHarvestEntry(playerUUID, pos);
            }
        } else {
            this.startHarvest(playerUUID, pos);
            playerIn.func_145747_a((ITextComponent)new TextComponentString("\u00a7aR\u00e9colte en cours..."));
        }
        return true;
    }

    private void completeImmatureHarvest(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, CookToolItem tool, IMinePieceData mpData) {
        if (playerIn instanceof EntityPlayerMP) {
            PlayerUtils.addJobXpToPlayer((EntityPlayerMP)playerIn, this.jobXpAmount / 2 + tool.getXpBonus() / 2);
        }
        playerIn.func_184614_ca().func_77972_a(1, (EntityLivingBase)playerIn);
        if (this.immatureFoodItem != null) {
            ItemStack itemStack = new ItemStack(this.immatureFoodItem);
            worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemStack));
            playerIn.func_145747_a((ITextComponent)new TextComponentString("\u00a7aR\u00e9colte termin\u00e9e! Vous avez obtenu un fruit immature."));
        } else {
            playerIn.func_145747_a((ITextComponent)new TextComponentString("\u00a7aR\u00e9colte termin\u00e9e! Le fruit n'\u00e9tait pas encore m\u00fbr."));
        }
        if (this.nextStateBlock != null) {
            worldIn.func_175656_a(pos, this.nextStateBlock.func_176223_P());
            this.scheduleGrowth(worldIn, pos, this.nextStateBlock);
        } else {
            worldIn.func_175698_g(pos);
        }
    }

    private void completeMatureHarvest(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, CookToolItem tool, IMinePieceData mpData) {
        if (playerIn instanceof EntityPlayerMP) {
            PlayerUtils.addJobXpToPlayer((EntityPlayerMP)playerIn, this.jobXpAmount + tool.getXpBonus());
            mpData.clientSync((EntityPlayerMP)playerIn);
        }
        playerIn.func_184614_ca().func_77972_a(1, (EntityLivingBase)playerIn);
        playerIn.func_145747_a((ITextComponent)new TextComponentString("\u00a7aR\u00e9colte termin\u00e9e!"));
        if (this.foodItem != null) {
            ItemStack itemStack = new ItemStack(this.foodItem);
            worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemStack));
        }
        if (this.nextStateBlock != null) {
            worldIn.func_175656_a(pos, this.nextStateBlock.func_176223_P());
            this.scheduleGrowth(worldIn, pos, this.nextStateBlock);
        } else {
            worldIn.func_175698_g(pos);
        }
    }

    @Override
    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            if (!this.isMature) {
                this.scheduleGrowth(worldIn, pos, this);
            } else if (this.isImmature) {
                this.scheduleGrowthToMature(worldIn, pos, this);
            }
        }
    }

    protected void scheduleGrowthToMature(World world, BlockPos pos, Block currentBlock) {
        FlowerTileEntity flowerTE;
        if (this.isImmature && this.matureBlockName != null && !this.matureBlockName.isEmpty() && (flowerTE = this.getFruitTileEntity(world, pos)) != null) {
            int growthTime = 12000;
            flowerTE.setGrowthTime(growthTime);
            flowerTE.setNextGrowthBlock(this.matureBlockName);
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
            world.func_175646_b(pos, (TileEntity)flowerTE);
        }
    }

    private FlowerTileEntity getFruitTileEntity(World world, BlockPos pos) {
        FlowerTileEntity flowerTE;
        TileEntity existingTE = world.func_175625_s(pos);
        if (existingTE != null && !(existingTE instanceof FlowerTileEntity)) {
            world.func_175713_t(pos);
            existingTE = null;
        }
        if (existingTE instanceof FlowerTileEntity) {
            flowerTE = (FlowerTileEntity)existingTE;
        } else {
            flowerTE = new FlowerTileEntity();
            world.func_175690_a(pos, (TileEntity)flowerTE);
        }
        return flowerTE;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }
}

