/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.plantable;

import fr.minepiece.MinePiece;
import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.blocks.plantable.FlowerTileEntity;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.items.jobs.JobToolItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractFlowerBlock
extends Block {
    protected static final AxisAlignedBB FLOWER_AABB = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.6, 0.7);
    protected static final Map<UUID, Map<BlockPos, Long>> harvestingPlayers = new HashMap<UUID, Map<BlockPos, Long>>();
    protected static final long HARVEST_TIME = 2000L;
    protected static final int DEFAULT_GROWTH_TIME = 12000;
    protected static final int TEST_GROWTH_TIME = 200;
    protected final int jobXpAmount;
    protected final MinePieceJobs requiredJob;
    protected final boolean isMature;
    protected final Block cutStateBlock;
    protected final String matureBlockName;

    public AbstractFlowerBlock(String name, Material material, int jobXpAmount, MinePieceJobs requiredJob, String matureBlockName) {
        super(material);
        this.jobXpAmount = jobXpAmount;
        this.requiredJob = requiredJob;
        this.isMature = false;
        this.cutStateBlock = null;
        this.matureBlockName = matureBlockName;
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(MinePiece.CROPS);
    }

    public AbstractFlowerBlock(String name, Material material, int jobXpAmount, MinePieceJobs requiredJob, boolean isMature, Block cutStateBlock, String cutBlockName) {
        super(material);
        this.jobXpAmount = jobXpAmount;
        this.requiredJob = requiredJob;
        this.isMature = isMature;
        this.cutStateBlock = cutStateBlock;
        this.matureBlockName = null;
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(MinePiece.CROPS);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FLOWER_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (!this.isMature) {
            return -1.0f;
        }
        return 1.0f;
    }

    protected Item getHarvestDrop() {
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (!this.isMature) {
            return false;
        }
        ItemStack heldItem = playerIn.func_184586_b(hand);
        Item tool = heldItem.func_77973_b();
        if (!this.isValidTool(tool)) {
            return false;
        }
        JobToolItem jobTool = (JobToolItem)tool;
        IMinePieceData mpData = (IMinePieceData)playerIn.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (mpData == null || mpData.getJob() != this.requiredJob || !jobTool.isUsableAtLevel(mpData.getJobLevel())) {
            return false;
        }
        UUID playerUUID = playerIn.func_110124_au();
        if (this.isPlayerHarvesting(playerUUID, pos)) {
            long startTime = this.getHarvestStartTime(playerUUID, pos);
            long currentTime = System.currentTimeMillis();
            if (currentTime - startTime >= 2000L) {
                this.completeHarvest(worldIn, pos, state, playerIn, jobTool, mpData);
                this.removeHarvestEntry(playerUUID, pos);
            }
        } else {
            this.startHarvest(playerUUID, pos);
            playerIn.func_145747_a((ITextComponent)new TextComponentString("\u00a7aR\u00e9colte en cours..."));
        }
        return true;
    }

    protected void completeHarvest(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, JobToolItem jobTool, IMinePieceData mpData) {
        if (playerIn instanceof EntityPlayerMP) {
            PlayerUtils.addJobXpToPlayer((EntityPlayerMP)playerIn, this.jobXpAmount + jobTool.getXpBonus());
            mpData.clientSync((EntityPlayerMP)playerIn);
        }
        playerIn.func_184614_ca().func_77972_a(1, (EntityLivingBase)playerIn);
        playerIn.func_145747_a((ITextComponent)new TextComponentString("\u00a7aR\u00e9colte termin\u00e9e!"));
        Item dropItem = this.getHarvestDrop();
        if (this.isMature && this.cutStateBlock != null) {
            worldIn.func_175656_a(pos, this.cutStateBlock.func_176223_P());
            if (dropItem != null) {
                ItemStack itemStack = new ItemStack(dropItem);
                worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemStack));
            } else {
                ItemStack blockStack = new ItemStack(Item.func_150898_a((Block)this));
                worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, blockStack));
            }
            this.scheduleGrowth(worldIn, pos, this.cutStateBlock);
        } else if (!this.isMature) {
            worldIn.func_175698_g(pos);
        } else {
            if (dropItem != null) {
                ItemStack itemStack = new ItemStack(dropItem);
                worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemStack));
            } else {
                ItemStack blockStack = new ItemStack(Item.func_150898_a((Block)this));
                worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, blockStack));
            }
            worldIn.func_175698_g(pos);
        }
    }

    protected void scheduleGrowth(World world, BlockPos pos, Block currentBlock) {
        if (currentBlock instanceof AbstractFlowerBlock && !((AbstractFlowerBlock)currentBlock).isMature) {
            FlowerTileEntity flowerTE;
            TileEntity existingTE = world.func_175625_s(pos);
            if (existingTE != null && !(existingTE instanceof FlowerTileEntity)) {
                world.func_175713_t(pos);
                existingTE = null;
            }
            if (existingTE instanceof FlowerTileEntity) {
                flowerTE = (FlowerTileEntity)existingTE;
            } else {
                flowerTE = new FlowerTileEntity();
                world.func_175690_a(pos, (TileEntity)flowerTE);
            }
            int growthTime = 12000;
            flowerTE.setGrowthTime(growthTime);
            AbstractFlowerBlock flowerBlock = (AbstractFlowerBlock)currentBlock;
            String matureBlockName = flowerBlock.matureBlockName;
            if (matureBlockName != null && !matureBlockName.isEmpty()) {
                flowerTE.setNextGrowthBlock(matureBlockName);
            }
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
            world.func_175646_b(pos, (TileEntity)flowerTE);
        }
    }

    public static Block getBlockFromName(String name) {
        return Block.func_149684_b((String)("minepiece:" + name));
    }

    void startHarvest(UUID playerUUID, BlockPos pos) {
        harvestingPlayers.computeIfAbsent(playerUUID, k -> new HashMap()).put(pos, System.currentTimeMillis());
    }

    boolean isPlayerHarvesting(UUID playerUUID, BlockPos pos) {
        Map<BlockPos, Long> playerHarvests = harvestingPlayers.get(playerUUID);
        return playerHarvests != null && playerHarvests.containsKey(pos);
    }

    long getHarvestStartTime(UUID playerUUID, BlockPos pos) {
        Map<BlockPos, Long> playerHarvests = harvestingPlayers.get(playerUUID);
        return playerHarvests != null ? playerHarvests.getOrDefault(pos, 0L) : 0L;
    }

    void removeHarvestEntry(UUID playerUUID, BlockPos pos) {
        Map<BlockPos, Long> playerHarvests = harvestingPlayers.get(playerUUID);
        if (playerHarvests != null) {
            playerHarvests.remove(pos);
            if (playerHarvests.isEmpty()) {
                harvestingPlayers.remove(playerUUID);
            }
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        if (!this.isMature) {
            return false;
        }
        ItemStack heldItem = player.func_184614_ca();
        return this.isValidTool(heldItem.func_77973_b());
    }

    protected abstract boolean isValidTool(Item var1);

    public boolean hasTileEntity(IBlockState state) {
        return !this.isMature;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (!this.isMature) {
            return new FlowerTileEntity();
        }
        return null;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (!worldIn.field_72995_K && !this.isMature) {
            this.scheduleGrowth(worldIn, pos, this);
        }
    }
}

