/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.medic.recipes;

import fr.minepiece.common.blocks.jobs.crafting.medic.bancdemedicament.recipes.IBancDeMedicamentRecipe;
import fr.minepiece.common.blocks.jobs.crafting.medic.paillasse.recipes.IPaillasseRecipe;
import fr.minepiece.common.blocks.jobs.crafting.medic.paillasse.recipes.ShapelessPaillasseRecipe;
import fr.minepiece.common.items.jobs.medic.tools.MedicToolItem;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapelessPaillasseToBancDeMedicamentAdapter
implements IBancDeMedicamentRecipe {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Recipes");
    private final ShapelessPaillasseRecipe paillasseRecipe;
    private static final float XP_BONUS_MULTIPLIER = 0.25f;

    public ShapelessPaillasseToBancDeMedicamentAdapter(ShapelessPaillasseRecipe paillasseRecipe) {
        this.paillasseRecipe = paillasseRecipe;
        LOGGER.debug("Created shapeless adapter for recipe: {}", (Object)paillasseRecipe.func_77571_b().func_82833_r());
    }

    @Override
    public boolean matches(InventoryCrafting inv, World world) {
        int i;
        ArrayList ingredients = new ArrayList(this.paillasseRecipe.func_192400_c());
        boolean[] used = new boolean[36];
        Iterator iterator = ingredients.iterator();
        while (iterator.hasNext()) {
            Ingredient ingredient = (Ingredient)iterator.next();
            boolean found = false;
            for (int i2 = 0; i2 < 36; ++i2) {
                ItemStack stackInSlot;
                if (used[i2] || (stackInSlot = inv.func_70301_a(i2)).func_190926_b()) continue;
                if (this.isTool(stackInSlot.func_77973_b())) {
                    if (ingredient.func_193365_a().length <= 0) continue;
                    for (ItemStack matchStack : ingredient.func_193365_a()) {
                        if (stackInSlot.func_77973_b() != matchStack.func_77973_b()) continue;
                        used[i2] = true;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    iterator.remove();
                    break;
                }
                if (!ingredient.apply(stackInSlot)) continue;
                used[i2] = true;
                iterator.remove();
                found = true;
                break;
            }
            if (found) continue;
            LOGGER.debug("Recipe {} does not match: missing ingredient", (Object)this.getRecipeOutput().func_82833_r());
            return false;
        }
        for (i = 0; i < 36; ++i) {
            if (inv.func_70301_a(i).func_190926_b() || used[i]) continue;
            return false;
        }
        for (i = 36; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        boolean matches = ingredients.isEmpty();
        LOGGER.debug("Recipe match result for {}: {}", (Object)this.getRecipeOutput().func_82833_r(), (Object)matches);
        return matches;
    }

    private boolean isTool(Item item) {
        return item instanceof MedicToolItem;
    }

    @Override
    public int getLevelRequired() {
        return this.paillasseRecipe.getLevelRequired();
    }

    @Override
    public int getBaseXpReward() {
        return this.paillasseRecipe.getXpReward();
    }

    @Override
    public int getXpReward() {
        return this.paillasseRecipe.getXpReward();
    }

    @Override
    public int getXpBonus(int stationType) {
        return stationType == 2 ? (int)((float)this.getBaseXpReward() * 0.25f) : 0;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inv) {
        return this.paillasseRecipe.func_77571_b().func_77946_l();
    }

    @Override
    public int getRecipeSize() {
        return this.paillasseRecipe.getRecipeSize();
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.paillasseRecipe.func_77571_b();
    }

    @Override
    public boolean usesSpecialSlot(int slotIndex) {
        return false;
    }

    public IPaillasseRecipe getOriginalRecipe() {
        return this.paillasseRecipe;
    }
}

