/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.medic.pilon.tileentity;

import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.blocks.jobs.crafting.medic.pilon.recipes.ShapedPilonRecipe;
import fr.minepiece.common.craft.CraftingResult;
import fr.minepiece.common.craft.IMinePieceCraftingInventory;
import fr.minepiece.common.craft.IMinePieceCraftingRecipe;
import fr.minepiece.common.craft.MinePieceCraftingTileEntity;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class TileEntityPilon
extends MinePieceCraftingTileEntity {
    private static final int PROCESS_TIME_MAX = 200;
    private static final int INVENTORY_SIZE = 2;
    private static final int STATION_TYPE = 3;
    private boolean craftJustCompleted = false;

    public TileEntityPilon() {
        super(2);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.usingPlayer != null) {
            if (this.processTime > 0) {
                --this.processTime;
                if (this.processTime <= 0) {
                    this.processCraft();
                    this.craftJustCompleted = true;
                }
                this.func_70296_d();
            } else if (this.craftJustCompleted) {
                this.craftJustCompleted = false;
            } else {
                this.checkPendingCrafts();
                IMinePieceCraftingRecipe recipe = this.getCurrentRecipe();
                if (recipe != null && this.canCraft(recipe) && this.func_70301_a(this.getOutputSlot()).func_190926_b()) {
                    this.startCraftingProcess();
                }
            }
        }
    }

    @Override
    public int getWidth() {
        return 1;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public int getOutputSlot() {
        return 1;
    }

    @Override
    protected void startCraftingProcess() {
        this.processTime = 200;
        this.func_70296_d();
    }

    @Override
    protected int getStationType() {
        return 3;
    }

    @Override
    protected IMinePieceCraftingRecipe getCurrentRecipe() {
        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return null;
        }
        for (IRecipe irecipe : CraftingManager.field_193380_a) {
            ShapedPilonRecipe recipe;
            if (!(irecipe instanceof ShapedPilonRecipe) || !(recipe = (ShapedPilonRecipe)irecipe).matches(this, this.field_145850_b)) continue;
            return new PilonRecipeAdapter(recipe);
        }
        return null;
    }

    @Override
    protected void processCraft() {
        if (this.usingPlayer == null) {
            return;
        }
        IMinePieceCraftingRecipe recipe = this.getCurrentRecipe();
        if (recipe == null || !this.canCraft(recipe)) {
            return;
        }
        CraftingResult result = recipe.getCraftingResult(this);
        if (result.getResult().func_190926_b()) {
            return;
        }
        if (!this.setOutput(result.getResult())) {
            this.craftResult = result.getCraftCount();
            this.pendingConsumptions = result.getConsumedItems();
            return;
        }
        for (CraftingResult.ItemPosition itemPos : result.getConsumedItems()) {
            int slot = itemPos.slot;
            ItemStack stack = this.func_70301_a(slot);
            stack.func_190918_g(itemPos.count);
            if (!stack.func_190926_b()) continue;
            this.func_70299_a(slot, ItemStack.field_190927_a);
        }
        this.handleSuccessfulCraft(recipe, result);
    }

    public World func_145831_w() {
        return this.field_145850_b;
    }

    public String func_70005_c_() {
        return "container.pilon";
    }

    public boolean func_145818_k_() {
        return false;
    }

    private class PilonRecipeAdapter
    implements IMinePieceCraftingRecipe {
        private final ShapedPilonRecipe recipe;

        public PilonRecipeAdapter(ShapedPilonRecipe recipe) {
            this.recipe = recipe;
        }

        @Override
        public boolean matches(IMinePieceCraftingInventory inventory, World world) {
            return this.recipe.matches(TileEntityPilon.this, world);
        }

        @Override
        public int getLevelRequired() {
            return this.recipe.getLevelRequired();
        }

        @Override
        public int getBaseXpReward() {
            return this.recipe.getXpReward();
        }

        @Override
        public MinePieceJobs getRequiredJob() {
            return this.recipe.getRequiredJob();
        }

        @Override
        public CraftingResult getCraftingResult(IMinePieceCraftingInventory inventory) {
            ItemStack result = this.recipe.getCraftingResult(TileEntityPilon.this);
            if (result.func_190926_b()) {
                return new CraftingResult(ItemStack.field_190927_a, 0, new ArrayList<CraftingResult.ItemPosition>());
            }
            ArrayList<CraftingResult.ItemPosition> consumedItems = new ArrayList<CraftingResult.ItemPosition>();
            ItemStack input = TileEntityPilon.this.func_70301_a(0);
            if (!input.func_190926_b()) {
                consumedItems.add(new CraftingResult.ItemPosition(0, 1));
            }
            return new CraftingResult(result, 1, consumedItems);
        }

        @Override
        public ItemStack getRecipeOutput() {
            return this.recipe.func_77571_b();
        }

        @Override
        public float getXpMultiplier(int stationType) {
            return stationType == 3 ? 1.0f : 0.0f;
        }
    }
}

