/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.medic.pilon.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.blocks.jobs.crafting.medic.pilon.recipes.IPilonRecipe;
import fr.minepiece.common.blocks.jobs.crafting.medic.pilon.tileentity.TileEntityPilon;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapedPilonRecipe
extends ShapedOreRecipe
implements IPilonRecipe {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Recipes");
    private final int levelRequired;
    private final int xpReward;
    private final Ingredient input;
    private final MinePieceJobs requiredJob;

    public ShapedPilonRecipe(ResourceLocation group, @Nonnull ItemStack result, Ingredient input, int levelRequired, int xpReward, MinePieceJobs requiredJob) {
        super(group, result, new CraftingHelper.ShapedPrimer());
        LOGGER.debug("Creating new ShapedPilonRecipe:");
        LOGGER.debug(" - Group: {}", (Object)group);
        LOGGER.debug(" - Result: {}", (Object)result);
        LOGGER.debug(" - Level Required: {}", (Object)levelRequired);
        LOGGER.debug(" - XP Reward: {}", (Object)xpReward);
        LOGGER.debug(" - Job Required: {}", (Object)requiredJob.getName());
        this.levelRequired = levelRequired;
        this.xpReward = xpReward;
        this.input = input;
        this.requiredJob = requiredJob;
    }

    @Override
    public boolean matches(TileEntityPilon inv, World world) {
        ItemStack inputStack = inv.func_70301_a(0);
        return !inputStack.func_190926_b() && this.input.apply(inputStack);
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return false;
    }

    @Override
    public int getLevelRequired() {
        return this.levelRequired;
    }

    @Override
    public int getXpReward() {
        return this.xpReward;
    }

    @Override
    public MinePieceJobs getRequiredJob() {
        return this.requiredJob;
    }

    @Override
    public ItemStack getCraftingResult(TileEntityPilon inv) {
        return this.func_77571_b().func_77946_l();
    }

    public ItemStack func_77571_b() {
        return super.func_77571_b();
    }

    public static class RecipeFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            LOGGER.debug("Parsing recipe JSON: {}", (Object)json);
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            try {
                MinePieceJobs requiredJob;
                JsonObject ingredientJson = JsonUtils.func_152754_s((JsonObject)json, (String)"input");
                Ingredient input = CraftingHelper.getIngredient((JsonElement)ingredientJson, (JsonContext)context);
                if (input == Ingredient.field_193370_a) {
                    throw new JsonSyntaxException("Invalid input ingredient");
                }
                ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
                if (result.func_190926_b()) {
                    throw new JsonSyntaxException("Invalid or empty result item");
                }
                int levelRequired = JsonUtils.func_151208_a((JsonObject)json, (String)"level_required", (int)1);
                int xpReward = JsonUtils.func_151208_a((JsonObject)json, (String)"xp_reward", (int)0);
                String jobName = JsonUtils.func_151219_a((JsonObject)json, (String)"job", (String)"MEDIC");
                try {
                    requiredJob = MinePieceJobs.valueOf(jobName.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Invalid job name '{}' specified for recipe. Defaulting to MEDIC", (Object)jobName);
                    requiredJob = MinePieceJobs.MEDIC;
                }
                return new ShapedPilonRecipe(group.isEmpty() ? null : new ResourceLocation(group), result, input, levelRequired, xpReward, requiredJob);
            }
            catch (Exception e) {
                LOGGER.error("Error parsing recipe: {}", (Object)e.getMessage());
                LOGGER.error("Recipe JSON: {}", (Object)json);
                throw e;
            }
        }
    }
}

