/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.medic.pilon;

import com.google.common.base.Predicate;
import fr.minepiece.MinePiece;
import fr.minepiece.common.blocks.BlockMinePiece;
import fr.minepiece.common.blocks.jobs.crafting.medic.pilon.tileentity.TileEntityPilon;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class BlockPilon
extends BlockMinePiece {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private final int requiredLevel;

    public BlockPilon(Material material, String name, int requiredLevel) {
        super(material, name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.requiredLevel = requiredLevel;
        this.func_149713_g(0);
        this.func_149647_a(MinePiece.JOBS);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        Capability<IMinePieceData> capability = MinePieceDataStorage.MP_DATA_CAPABILITY;
        IMinePieceData mpData = (IMinePieceData)playerIn.getCapability(capability, null);
        if (mpData == null) {
            return false;
        }
        if (mpData.getJobLevel() < this.requiredLevel) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.pilon.level_too_low", new Object[]{this.requiredLevel}));
            return false;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof TileEntityPilon)) {
            return false;
        }
        playerIn.openGui((Object)MinePiece.INSTANCE, 201, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.125, -0.046875, 0.125, 0.875, 0.5625, 0.875);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityPilon();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

