/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.medic.paillasse.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.blocks.jobs.crafting.medic.paillasse.recipes.IPaillasseRecipe;
import fr.minepiece.common.craft.AbstractShapedMinePieceRecipe;
import fr.minepiece.common.craft.CraftingResult;
import fr.minepiece.common.craft.IMinePieceCraftingInventory;
import fr.minepiece.common.init.ModTools;
import fr.minepiece.common.items.jobs.medic.tools.MedicToolItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapedPaillasseRecipe
extends AbstractShapedMinePieceRecipe
implements IPaillasseRecipe {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Recipes");
    private static final int MAX_GRID_WIDTH = 6;
    private static final int MAX_GRID_HEIGHT = 6;
    private final int recipeWidth;
    private final int recipeHeight;
    private final boolean[] specialSlotUsage;
    private final Ingredient[] specialSlotIngredients;

    public ShapedPaillasseRecipe(ResourceLocation group, @Nonnull ItemStack result, NonNullList<Ingredient> ingredients, int width, int height, int levelRequired, int xpReward, boolean[] specialSlotUsage, Ingredient[] specialSlotIngredients) {
        super(group, result, ingredients, width, height, levelRequired, xpReward, MinePieceJobs.MEDIC);
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.specialSlotUsage = specialSlotUsage;
        this.specialSlotIngredients = specialSlotIngredients;
        LOGGER.debug("Created ShapedPaillasseRecipe: {}x{}, result: {}, level: {}, xp: {}", (Object)width, (Object)height, (Object)result.func_82833_r(), (Object)levelRequired, (Object)xpReward);
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int startX = 0; startX <= 6 - this.recipeWidth; ++startX) {
            for (int startY = 0; startY <= 6 - this.recipeHeight; ++startY) {
                if (this.checkMatch(inv, startX, startY, false)) {
                    if (!this.specialSlotUsage[0] && !this.specialSlotUsage[1]) {
                        return true;
                    }
                    if (this.checkSpecialSlots(inv)) {
                        return true;
                    }
                }
                if (!this.checkMatch(inv, startX, startY, true)) continue;
                if (!this.specialSlotUsage[0] && !this.specialSlotUsage[1]) {
                    return true;
                }
                if (!this.checkSpecialSlots(inv)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkSpecialSlots(InventoryCrafting inv) {
        for (int i = 0; i < 2; ++i) {
            if (!this.specialSlotUsage[i]) continue;
            ItemStack specialItem = inv.func_70301_a(36 + i);
            if (specialItem.func_190926_b()) {
                return false;
            }
            if (!specialItem.func_190926_b() && this.isTool(specialItem.func_77973_b())) {
                boolean toolMatches = false;
                for (ItemStack matchStack : this.specialSlotIngredients[i].func_193365_a()) {
                    if (specialItem.func_77973_b() != matchStack.func_77973_b()) continue;
                    toolMatches = true;
                    break;
                }
                if (toolMatches) continue;
                return false;
            }
            if (this.specialSlotIngredients[i].apply(specialItem)) continue;
            return false;
        }
        return true;
    }

    public boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirrored) {
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 6; ++y) {
                int invIndex;
                if (x >= startX && x < startX + this.recipeWidth && y >= startY && y < startY + this.recipeHeight || (invIndex = y * 6 + x) >= 36 || inv.func_70301_a(invIndex).func_190926_b()) continue;
                return false;
            }
        }
        for (int y = 0; y < this.recipeHeight; ++y) {
            for (int x = 0; x < this.recipeWidth; ++x) {
                int invIndex;
                int invX = startX + x;
                int invY = startY + y;
                if (invX >= 6 || invY >= 6 || (invIndex = invY * 6 + invX) >= 36) continue;
                Ingredient expectedIngredient = mirrored ? (Ingredient)this.ingredients.get(this.recipeWidth - x - 1 + y * this.recipeWidth) : (Ingredient)this.ingredients.get(x + y * this.recipeWidth);
                ItemStack stack = inv.func_70301_a(invIndex);
                if (expectedIngredient == Ingredient.field_193370_a) {
                    if (stack.func_190926_b()) continue;
                    return false;
                }
                if (!stack.func_190926_b() && this.isTool(stack.func_77973_b())) {
                    boolean toolMatches = false;
                    for (ItemStack matchStack : expectedIngredient.func_193365_a()) {
                        if (stack.func_77973_b() != matchStack.func_77973_b()) continue;
                        toolMatches = true;
                        break;
                    }
                    if (toolMatches) continue;
                    return false;
                }
                if (expectedIngredient.apply(stack)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean matches(IMinePieceCraftingInventory inventory, World world) {
        if (inventory instanceof InventoryCrafting) {
            return this.func_77569_a((InventoryCrafting)inventory, world);
        }
        return false;
    }

    @Override
    public CraftingResult getCraftingResult(IMinePieceCraftingInventory inventory) {
        if (!(inventory instanceof InventoryCrafting)) {
            return new CraftingResult(ItemStack.field_190927_a, 0, new ArrayList<CraftingResult.ItemPosition>());
        }
        InventoryCrafting craftMatrix = (InventoryCrafting)inventory;
        if (!this.func_77569_a(craftMatrix, inventory.getWorld())) {
            return new CraftingResult(ItemStack.field_190927_a, 0, new ArrayList<CraftingResult.ItemPosition>());
        }
        HashMap<Integer, ItemStack> usedIngredients = new HashMap<Integer, ItemStack>();
        ArrayList remainingIngredients = new ArrayList(this.func_192400_c());
        boolean[] used = new boolean[36];
        Iterator iterator = remainingIngredients.iterator();
        block0: while (iterator.hasNext()) {
            int i;
            Ingredient ingredient = (Ingredient)iterator.next();
            boolean bl = false;
            for (i = 0; i < 36; ++i) {
                ItemStack stackInSlot;
                if (used[i] || (stackInSlot = craftMatrix.func_70301_a(i)).func_190926_b()) continue;
                if (this.isTool(stackInSlot.func_77973_b())) {
                    for (ItemStack matchStack : ingredient.func_193365_a()) {
                        if (stackInSlot.func_77973_b() != matchStack.func_77973_b()) continue;
                        usedIngredients.put(i, stackInSlot);
                        used[i] = true;
                        bl = true;
                        break;
                    }
                } else if (ingredient.apply(stackInSlot)) {
                    usedIngredients.put(i, stackInSlot);
                    used[i] = true;
                    bl = true;
                }
                if (!bl) continue;
                iterator.remove();
                break;
            }
            if (bl) continue;
            for (i = 0; i < 2; ++i) {
                ItemStack specialStack;
                if (!this.specialSlotUsage[i] || (specialStack = craftMatrix.func_70301_a(36 + i)).func_190926_b()) continue;
                if (this.isTool(specialStack.func_77973_b())) {
                    for (ItemStack matchStack : ingredient.func_193365_a()) {
                        if (specialStack.func_77973_b() != matchStack.func_77973_b()) continue;
                        usedIngredients.put(36 + i, specialStack);
                        bl = true;
                        break;
                    }
                } else if (ingredient.apply(specialStack)) {
                    usedIngredients.put(36 + i, specialStack);
                    bl = true;
                }
                if (!bl) continue;
                iterator.remove();
                continue block0;
            }
        }
        int minMultiplier = Integer.MAX_VALUE;
        for (Map.Entry entry : usedIngredients.entrySet()) {
            ItemStack stack = (ItemStack)entry.getValue();
            if (stack.func_190926_b() || this.isTool(stack.func_77973_b())) continue;
            minMultiplier = Math.min(minMultiplier, stack.func_190916_E());
        }
        if (minMultiplier == Integer.MAX_VALUE || minMultiplier <= 0) {
            minMultiplier = 1;
        }
        ArrayList<CraftingResult.ItemPosition> consumedItems = new ArrayList<CraftingResult.ItemPosition>();
        for (Map.Entry entry : usedIngredients.entrySet()) {
            int slotIndex = (Integer)entry.getKey();
            ItemStack stack = (ItemStack)entry.getValue();
            if (stack.func_190926_b()) continue;
            if (!this.isTool(stack.func_77973_b())) {
                consumedItems.add(new CraftingResult.ItemPosition(slotIndex, minMultiplier));
                continue;
            }
            consumedItems.add(new CraftingResult.ItemPosition(slotIndex, 0));
        }
        ItemStack itemStack = this.func_77571_b().func_77946_l();
        itemStack.func_190920_e(itemStack.func_190916_E() * minMultiplier);
        return new CraftingResult(itemStack, minMultiplier, consumedItems);
    }

    @Override
    public boolean usesSpecialSlot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.specialSlotUsage.length) {
            return false;
        }
        return this.specialSlotUsage[slotIndex];
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.func_77571_b().func_77946_l();
    }

    @Override
    public int getRecipeSize() {
        return this.recipeWidth * this.recipeHeight;
    }

    @Override
    public ItemStack func_77571_b() {
        return super.func_77571_b();
    }

    @Override
    public int getXpReward() {
        return super.getBaseXpReward();
    }

    @Override
    public MinePieceJobs getRequiredJob() {
        return MinePieceJobs.MEDIC;
    }

    private boolean isTool(Item item) {
        return item == ModTools.SCISSORS || item == ModTools.SCALPEL || item == ModTools.SICKLE || item == ModTools.GOLDEN_SICKLE || item instanceof MedicToolItem;
    }

    public int getWidth() {
        return this.recipeWidth;
    }

    public int getHeight() {
        return this.recipeHeight;
    }

    public static class RecipeFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            try {
                HashMap<Character, Ingredient> ingredientMap = new HashMap<Character, Ingredient>();
                for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
                    if (((String)entry.getKey()).length() != 1) {
                        throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                    }
                    if (" ".equals(entry.getKey())) {
                        throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                    }
                    ingredientMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
                }
                ingredientMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
                JsonArray pattern = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
                if (pattern.size() == 0) {
                    throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
                }
                if (pattern.size() > 6) {
                    throw new JsonSyntaxException("Invalid pattern: too many rows, 6 is maximum");
                }
                String[] rows = new String[pattern.size()];
                for (int i = 0; i < rows.length; ++i) {
                    String row = JsonUtils.func_151206_a((JsonElement)pattern.get(i), (String)("pattern[" + i + "]"));
                    if (row.length() > 6) {
                        throw new JsonSyntaxException("Invalid pattern: too many columns, 6 is maximum");
                    }
                    rows[i] = row;
                }
                int width = rows[0].length();
                int height = rows.length;
                NonNullList ingredients = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
                HashSet keys = new HashSet(ingredientMap.keySet());
                keys.remove(Character.valueOf(' '));
                for (int y = 0; y < height; ++y) {
                    String row = rows[y];
                    for (int x = 0; x < row.length(); ++x) {
                        char c = row.charAt(x);
                        Ingredient ingredient = (Ingredient)ingredientMap.get(Character.valueOf(c));
                        if (ingredient == null) {
                            throw new JsonSyntaxException("Pattern references symbol '" + c + "' but it's not defined in the key");
                        }
                        ingredients.set(x + y * width, (Object)ingredient);
                        keys.remove(Character.valueOf(c));
                    }
                }
                if (!keys.isEmpty()) {
                    throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
                }
                boolean[] specialSlotUsage = new boolean[2];
                Ingredient[] specialSlotIngredients = new Ingredient[2];
                if (json.has("special_slots")) {
                    JsonObject specialSlots = JsonUtils.func_152754_s((JsonObject)json, (String)"special_slots");
                    if (specialSlots.has("slot1")) {
                        specialSlotUsage[0] = true;
                        specialSlotIngredients[0] = CraftingHelper.getIngredient((JsonElement)specialSlots.get("slot1"), (JsonContext)context);
                    }
                    if (specialSlots.has("slot2")) {
                        specialSlotUsage[1] = true;
                        specialSlotIngredients[1] = CraftingHelper.getIngredient((JsonElement)specialSlots.get("slot2"), (JsonContext)context);
                    }
                }
                JsonObject resultJson = JsonUtils.func_152754_s((JsonObject)json, (String)"result");
                ItemStack result = CraftingHelper.getItemStack((JsonObject)resultJson, (JsonContext)context);
                if (resultJson.has("nbt")) {
                    try {
                        String nbtString = resultJson.get("nbt").getAsString();
                        NBTTagCompound nbt = JsonToNBT.func_180713_a((String)nbtString);
                        result.func_77982_d(nbt);
                    }
                    catch (NBTException e) {
                        throw new JsonSyntaxException("Invalid NBT for recipe result: " + e.getMessage());
                    }
                }
                int levelRequired = JsonUtils.func_151208_a((JsonObject)json, (String)"level_required", (int)1);
                int xpReward = JsonUtils.func_151208_a((JsonObject)json, (String)"xp_reward", (int)0);
                return new ShapedPaillasseRecipe(group.isEmpty() ? null : new ResourceLocation(group), result, (NonNullList<Ingredient>)ingredients, width, height, levelRequired, xpReward, specialSlotUsage, specialSlotIngredients);
            }
            catch (Exception e) {
                LOGGER.error("Error parsing recipe: {}", (Object)e.getMessage());
                throw e;
            }
        }
    }
}

