/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.medic.extracteur.tileentity;

import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.blocks.jobs.crafting.medic.extracteur.BlockExtracteur;
import fr.minepiece.common.blocks.jobs.crafting.medic.extracteur.recipes.ExtracteurRecipes;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.init.ModItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileEntityExtracteur
extends TileEntity
implements IInventory,
ITickable {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Recipes");
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    private String customName;
    private int extractTime;
    private int currentExtractTime;
    private int cookTime;
    private int totalCookTime;

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.extracteur";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && index + 1 == 1 && !flag) {
            ItemStack stack1 = (ItemStack)this.inventory.get(index + 1);
            this.totalCookTime = this.getCookTime(stack, stack1);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.extractTime = compound.func_74762_e("ExtractTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("TotalCookTime");
        this.currentExtractTime = TileEntityExtracteur.getItemExtractTime((ItemStack)this.inventory.get(2));
        if (compound.func_150297_b("CustomName", 8)) {
            this.setCustomName(compound.func_74779_i("CustomName"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("ExtractTime", this.extractTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("TotalCookTime", this.totalCookTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isExtracting() {
        return this.extractTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isExtracting(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isExtracting();
        boolean flag1 = false;
        if (this.isExtracting()) {
            --this.extractTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack result;
            ItemStack input = (ItemStack)this.inventory.get(0);
            ItemStack fuel = (ItemStack)this.inventory.get(1);
            if (!(input.func_190926_b() || this.isExtracting() || (result = ExtracteurRecipes.getInstance().getExtracteurResult(input)).func_190926_b() || fuel.func_190926_b() || !TileEntityExtracteur.isItemFuel(fuel))) {
                this.currentExtractTime = this.extractTime = TileEntityExtracteur.getItemExtractTime(fuel);
                this.totalCookTime = 200;
                fuel.func_190918_g(1);
                flag1 = true;
                this.func_70296_d();
            }
            if (this.isExtracting()) {
                ++this.cookTime;
                if (this.cookTime >= this.totalCookTime) {
                    this.cookTime = 0;
                    this.extractedItem();
                    flag1 = true;
                }
            } else {
                this.cookTime = 0;
            }
            if (flag != this.isExtracting()) {
                flag1 = true;
                BlockExtracteur.setState(this.isExtracting(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getCookTime(ItemStack input1, ItemStack input2) {
        return 400;
    }

    private boolean canBeExtract() {
        ItemStack input = (ItemStack)this.inventory.get(0);
        ItemStack fuel = (ItemStack)this.inventory.get(1);
        if (input.func_190926_b() || fuel.func_190926_b()) {
            return false;
        }
        ItemStack result = ExtracteurRecipes.getInstance().getExtracteurResult(input);
        if (result.func_190926_b()) {
            return false;
        }
        ItemStack output = (ItemStack)this.inventory.get(2);
        if (output.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(result)) {
            return false;
        }
        int res = output.func_190916_E() + result.func_190916_E();
        return res <= this.func_70297_j_() && res <= output.func_77976_d();
    }

    public void extractedItem() {
        IMinePieceData mpData;
        ItemStack input = (ItemStack)this.inventory.get(0);
        ItemStack result = ExtracteurRecipes.getInstance().getExtracteurResult(input);
        if (result.func_190926_b()) {
            return;
        }
        ItemStack output = (ItemStack)this.inventory.get(2);
        EntityPlayer player = this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0, false);
        if (player != null && (mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) != null) {
            float experience = ExtracteurRecipes.getInstance().getExtracteurExperience(result);
            PlayerUtils.addJobXpToPlayer((EntityPlayerMP)player, (int)experience);
            mpData.clientSync((EntityPlayerMP)player);
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7aCraft r\u00e9ussi ! \u00a76+" + (int)experience + " XP"));
            if (mpData.getDailyCraftLimit() > 0) {
                mpData.setDailyCraftLimit(mpData.getDailyCraftLimit() - 1);
                mpData.clientSync((EntityPlayerMP)player);
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7aCraft journalier restant : \u00a76" + mpData.getDailyCraftLimit()));
            }
        }
        if (output.func_190926_b()) {
            this.inventory.set(2, (Object)result.func_77946_l());
        } else if (output.func_77973_b() == result.func_77973_b()) {
            output.func_190917_f(result.func_190916_E());
        } else {
            return;
        }
        input.func_190918_g(1);
    }

    public static int getItemExtractTime(ItemStack stack) {
        if (!TileEntityExtracteur.isItemFuel(stack)) {
            return 0;
        }
        return 400;
    }

    public static boolean isItemFuel(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b() == ModItems.FIOLE_VIDE;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        return TileEntityExtracteur.isItemFuel(stack);
    }

    public String getGuiID() {
        return "minepiece:extracteur";
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.extractTime;
            }
            case 1: {
                return this.currentExtractTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.extractTime = value;
                break;
            }
            case 1: {
                this.currentExtractTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }
}

