/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.medic.extracteur.recipes;

import com.google.common.collect.Maps;
import fr.minepiece.common.init.ModBlocks;
import fr.minepiece.common.init.ModItems;
import fr.minepiece.common.init.ModTools;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class ExtracteurRecipes {
    private static final ExtracteurRecipes INSTANCE = new ExtracteurRecipes();
    private final Map<ItemStack, ItemStack> extractingList = Maps.newHashMap();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();

    public static ExtracteurRecipes getInstance() {
        return INSTANCE;
    }

    private ExtracteurRecipes() {
        this.addExtracteurRecipe(new ItemStack(ModItems.NARCOBERRY), new ItemStack(ModItems.POUDRE_NARCOTIQUE), 2, 15.0f);
        this.addExtracteurRecipe(new ItemStack(ModItems.POUDRE_ANCOLI), new ItemStack(ModItems.ALCOOL_DESINFECTER), 2, 16.0f);
        this.addExtracteurRecipe(new ItemStack((Block)ModBlocks.POLLEN_PRISMATIQUE), new ItemStack(ModItems.REMEDE), 2, 18.0f);
        this.addExtracteurRecipe(new ItemStack(ModItems.POUDRE_LAVANDE), new ItemStack(ModItems.EXTRAIT_LAVANDE), 2, 18.0f);
        this.addExtracteurRecipe(new ItemStack(ModItems.POUDRE_FEU), new ItemStack(ModItems.EXTRAIT_FEU), 2, 19.0f);
        this.addExtracteurRecipe(new ItemStack(ModItems.TOXINE_BOTULIQUE), new ItemStack(ModTools.POTION_POISON), 2, 19.0f);
    }

    public void addExtracteurRecipe(ItemStack input, ItemStack result, int levelRequired, float experience) {
        if (this.getExtracteurResult(input) != ItemStack.field_190927_a) {
            return;
        }
        this.extractingList.put(input, result);
        this.experienceList.put(result, Float.valueOf(experience));
    }

    public ItemStack getExtracteurResult(ItemStack input) {
        System.out.println("[ExtracteurRecipes] Recherche recette pour: " + input);
        for (Map.Entry<ItemStack, ItemStack> entry : this.extractingList.entrySet()) {
            System.out.println("[ExtracteurRecipes] Comparaison avec: " + entry.getKey());
            if (!this.compareItemStacks(input, entry.getKey())) continue;
            System.out.println("[ExtracteurRecipes] Recette trouv\u00e9e! R\u00e9sultat: " + entry.getValue());
            return entry.getValue().func_77946_l();
        }
        System.out.println("[ExtracteurRecipes] Aucune recette trouv\u00e9e");
        return ItemStack.field_190927_a;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_190926_b() || stack2.func_190926_b()) {
            System.out.println("[ExtracteurRecipes] Un des stacks est vide");
            return false;
        }
        boolean result = stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
        System.out.println("[ExtracteurRecipes] Comparaison stacks:");
        System.out.println(" - Stack1: " + stack1.func_77973_b() + " (meta: " + stack1.func_77960_j() + ")");
        System.out.println(" - Stack2: " + stack2.func_77973_b() + " (meta: " + stack2.func_77960_j() + ")");
        System.out.println(" - R\u00e9sultat: " + result);
        return result;
    }

    public Map<ItemStack, ItemStack> getDualExtractingList() {
        return this.extractingList;
    }

    public float getExtracteurExperience(ItemStack stack) {
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

