/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.medic.extracteur;

import fr.minepiece.MinePiece;
import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.blocks.BlockMinePiece;
import fr.minepiece.common.blocks.jobs.crafting.medic.extracteur.tileentity.TileEntityExtracteur;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.init.ModBlocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class BlockExtracteur
extends BlockMinePiece
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool EXTRACTING = PropertyBool.func_177716_a((String)"extracting");
    private final int requiredLevel;

    public BlockExtracteur(Material material, String name, int requiredLevel) {
        super(material, name);
        this.func_149672_a(SoundType.field_185851_d);
        this.requiredLevel = requiredLevel;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)EXTRACTING, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(MinePiece.JOBS);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.EXTRACTEUR);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)ModBlocks.EXTRACTEUR);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            Capability<IMinePieceData> capability = MinePieceDataStorage.MP_DATA_CAPABILITY;
            IMinePieceData mpData = (IMinePieceData)playerIn.getCapability(capability, null);
            if (mpData == null) {
                return false;
            }
            if (mpData.getJob() != MinePieceJobs.MEDIC) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.extracteur.wrong_job", new Object[0]));
                return false;
            }
            if (mpData.getJobLevel() < this.requiredLevel) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.extracteur.level_too_low", new Object[]{this.requiredLevel}));
                return false;
            }
            if (mpData.getDailyCraftLimit() <= 0) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.extracteur.daily_limit", new Object[0]));
                return false;
            }
            playerIn.openGui((Object)MinePiece.INSTANCE, 202, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState north = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState south = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState west = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState east = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (face == EnumFacing.NORTH && north.func_185913_b() && !south.func_185913_b()) {
                face = EnumFacing.SOUTH;
            } else if (face == EnumFacing.SOUTH && south.func_185913_b() && !north.func_185913_b()) {
                face = EnumFacing.NORTH;
            } else if (face == EnumFacing.WEST && west.func_185913_b() && !east.func_185913_b()) {
                face = EnumFacing.EAST;
            } else if (face == EnumFacing.EAST && east.func_185913_b() && !west.func_185913_b()) {
                face = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)face), 2);
        }
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (active) {
            worldIn.func_180501_a(pos, ModBlocks.EXTRACTEUR.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)EXTRACTING, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            worldIn.func_180501_a(pos, ModBlocks.EXTRACTEUR.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)EXTRACTING, (Comparable)Boolean.valueOf(false)), 3);
        }
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityExtracteur();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityExtracteur tileentity = (TileEntityExtracteur)worldIn.func_175625_s(pos);
        InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)tileentity);
        super.func_180663_b(worldIn, pos, state);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EXTRACTING, FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }
}

