/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.medic.bancdemedicament.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fr.minepiece.common.blocks.jobs.crafting.medic.bancdemedicament.recipes.IBancDeMedicamentRecipe;
import fr.minepiece.common.items.jobs.medic.tools.MedicToolItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapedBancDeMedicamentRecipe
extends ShapedOreRecipe
implements IBancDeMedicamentRecipe {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Recipes");
    private static final int MAX_GRID_WIDTH = 6;
    private static final int MAX_GRID_HEIGHT = 6;
    private final int levelRequired;
    private final int xpReward;
    private final boolean[] specialSlotUsage;
    private final Ingredient[] specialSlotIngredients;

    public ShapedBancDeMedicamentRecipe(ResourceLocation group, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer, int levelRequired, int xpReward, boolean[] specialSlotUsage, Ingredient[] specialSlotIngredients) {
        super(group, result, primer);
        LOGGER.debug("Creating new ShapedBancDeMedicamentRecipe:");
        LOGGER.debug(" - Group: {}", (Object)group);
        LOGGER.debug(" - Result: {}", (Object)result.func_82833_r());
        LOGGER.debug(" - Level Required: {}", (Object)levelRequired);
        LOGGER.debug(" - XP Reward: {}", (Object)xpReward);
        LOGGER.debug(" - Grid size: {}x{}", (Object)primer.width, (Object)primer.height);
        this.levelRequired = levelRequired;
        this.xpReward = xpReward;
        this.specialSlotUsage = specialSlotUsage;
        this.specialSlotIngredients = specialSlotIngredients;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int startX = 0; startX <= 6 - this.getWidth(); ++startX) {
            for (int startY = 0; startY <= 6 - this.getHeight(); ++startY) {
                if (this.checkMatch(inv, startX, startY, false)) {
                    if (!this.specialSlotUsage[0] && !this.specialSlotUsage[1]) {
                        return true;
                    }
                    if (this.checkSpecialSlots(inv)) {
                        return true;
                    }
                }
                if (!this.checkMatch(inv, startX, startY, true)) continue;
                if (!this.specialSlotUsage[0] && !this.specialSlotUsage[1]) {
                    return true;
                }
                if (!this.checkSpecialSlots(inv)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkSpecialSlots(InventoryCrafting inv) {
        for (int i = 0; i < 2; ++i) {
            if (!this.specialSlotUsage[i]) continue;
            ItemStack specialItem = inv.func_70301_a(36 + i);
            if (specialItem.func_190926_b()) {
                return false;
            }
            if (!specialItem.func_190926_b() && this.isTool(specialItem.func_77973_b())) {
                boolean toolMatches = false;
                for (ItemStack matchStack : this.specialSlotIngredients[i].func_193365_a()) {
                    if (specialItem.func_77973_b() != matchStack.func_77973_b()) continue;
                    toolMatches = true;
                    break;
                }
                if (toolMatches) continue;
                return false;
            }
            if (this.specialSlotIngredients[i].apply(specialItem)) continue;
            return false;
        }
        return true;
    }

    public boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirrored) {
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 6; ++y) {
                int invIndex;
                if (x >= startX && x < startX + this.getWidth() && y >= startY && y < startY + this.getHeight() || (invIndex = y * 6 + x) >= 36 || inv.func_70301_a(invIndex).func_190926_b()) continue;
                return false;
            }
        }
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                int invIndex;
                int invX = startX + x;
                int invY = startY + y;
                if (invX >= 6 || invY >= 6 || (invIndex = invY * 6 + invX) >= 36) continue;
                Ingredient expectedIngredient = mirrored ? (Ingredient)this.func_192400_c().get(this.getWidth() - x - 1 + y * this.getWidth()) : (Ingredient)this.func_192400_c().get(x + y * this.getWidth());
                ItemStack stack = inv.func_70301_a(invIndex);
                if (expectedIngredient == Ingredient.field_193370_a) {
                    if (stack.func_190926_b()) continue;
                    return false;
                }
                if (!stack.func_190926_b() && this.isTool(stack.func_77973_b())) {
                    boolean toolMatches = false;
                    for (ItemStack matchStack : expectedIngredient.func_193365_a()) {
                        if (stack.func_77973_b() != matchStack.func_77973_b()) continue;
                        toolMatches = true;
                        break;
                    }
                    if (toolMatches) continue;
                    return false;
                }
                if (expectedIngredient.apply(stack)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isTool(Item item) {
        return item instanceof MedicToolItem;
    }

    @Override
    public int getBaseXpReward() {
        return this.xpReward;
    }

    @Override
    public int getLevelRequired() {
        return this.levelRequired;
    }

    @Override
    public int getXpReward() {
        return this.xpReward;
    }

    @Override
    public int getRecipeSize() {
        return 0;
    }

    @Override
    public boolean usesSpecialSlot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.specialSlotUsage.length) {
            return false;
        }
        return this.specialSlotUsage[slotIndex];
    }

    public Ingredient[] getSpecialSlotIngredients() {
        return this.specialSlotIngredients;
    }

    public static class RecipeFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            try {
                HashMap<Character, Ingredient> ingredientMap = new HashMap<Character, Ingredient>();
                for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
                    if (((String)entry.getKey()).length() != 1) {
                        throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                    }
                    if (" ".equals(entry.getKey())) {
                        throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                    }
                    ingredientMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
                }
                ingredientMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
                JsonArray pattern = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
                if (pattern.size() == 0) {
                    throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
                }
                if (pattern.size() > 6) {
                    throw new JsonSyntaxException("Invalid pattern: too many rows, 6 is maximum");
                }
                String[] rows = new String[pattern.size()];
                for (int i = 0; i < rows.length; ++i) {
                    String row = JsonUtils.func_151206_a((JsonElement)pattern.get(i), (String)("pattern[" + i + "]"));
                    if (row.length() > 6) {
                        throw new JsonSyntaxException("Invalid pattern: too many columns, 6 is maximum");
                    }
                    rows[i] = row;
                }
                int width = rows[0].length();
                int height = rows.length;
                NonNullList ingredients = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
                HashSet keys = new HashSet(ingredientMap.keySet());
                keys.remove(Character.valueOf(' '));
                for (int y = 0; y < height; ++y) {
                    String row = rows[y];
                    for (int x = 0; x < row.length(); ++x) {
                        char c = row.charAt(x);
                        Ingredient ingredient = (Ingredient)ingredientMap.get(Character.valueOf(c));
                        if (ingredient == null) {
                            throw new JsonSyntaxException("Pattern references symbol '" + c + "' but it's not defined in the key");
                        }
                        ingredients.set(x + y * width, (Object)ingredient);
                        keys.remove(Character.valueOf(c));
                    }
                }
                if (!keys.isEmpty()) {
                    throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
                }
                boolean[] specialSlotUsage = new boolean[2];
                Ingredient[] specialSlotIngredients = new Ingredient[2];
                if (json.has("special_slots")) {
                    JsonObject specialSlots = JsonUtils.func_152754_s((JsonObject)json, (String)"special_slots");
                    if (specialSlots.has("slot1")) {
                        specialSlotUsage[0] = true;
                        specialSlotIngredients[0] = CraftingHelper.getIngredient((JsonElement)specialSlots.get("slot1"), (JsonContext)context);
                    }
                    if (specialSlots.has("slot2")) {
                        specialSlotUsage[1] = true;
                        specialSlotIngredients[1] = CraftingHelper.getIngredient((JsonElement)specialSlots.get("slot2"), (JsonContext)context);
                    }
                }
                CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
                primer.width = width;
                primer.height = height;
                primer.mirrored = false;
                primer.input = ingredients;
                ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
                int levelRequired = JsonUtils.func_151208_a((JsonObject)json, (String)"level_required", (int)1);
                int xpReward = JsonUtils.func_151208_a((JsonObject)json, (String)"xp_reward", (int)0);
                return new ShapedBancDeMedicamentRecipe(group.isEmpty() ? null : new ResourceLocation(group), result, primer, levelRequired, xpReward, specialSlotUsage, specialSlotIngredients);
            }
            catch (Exception e) {
                LOGGER.error("Error parsing recipe: {}", (Object)e.getMessage());
                throw e;
            }
        }
    }
}

