/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.medic.bancdemedicament.recipes;

import fr.minepiece.common.blocks.jobs.crafting.medic.bancdemedicament.recipes.IBancDeMedicamentRecipe;
import fr.minepiece.common.blocks.jobs.crafting.medic.paillasse.recipes.ShapedPaillasseRecipe;
import fr.minepiece.common.blocks.jobs.crafting.medic.paillasse.recipes.ShapelessPaillasseRecipe;
import fr.minepiece.common.blocks.jobs.crafting.medic.recipes.PaillasseToBancDeMedicamentAdapter;
import fr.minepiece.common.blocks.jobs.crafting.medic.recipes.ShapelessPaillasseToBancDeMedicamentAdapter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BancDeMedicamentRecipeManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Recipes");
    private static final List<IBancDeMedicamentRecipe> adaptedRecipes = new ArrayList<IBancDeMedicamentRecipe>();
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        LOGGER.debug("Initializing BancDeMedicamentRecipeManager...");
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            IBancDeMedicamentRecipe adapter;
            if (recipe instanceof ShapedPaillasseRecipe) {
                adapter = new PaillasseToBancDeMedicamentAdapter((ShapedPaillasseRecipe)recipe);
                adaptedRecipes.add(adapter);
                LOGGER.debug("Adapted ShapedPaillasseRecipe: {}", (Object)recipe.func_77571_b().func_82833_r());
                continue;
            }
            if (recipe instanceof ShapelessPaillasseRecipe) {
                adapter = new ShapelessPaillasseToBancDeMedicamentAdapter((ShapelessPaillasseRecipe)recipe);
                adaptedRecipes.add(adapter);
                LOGGER.debug("Adapted ShapelessPaillasseRecipe: {}", (Object)recipe.func_77571_b().func_82833_r());
                continue;
            }
            if (!(recipe instanceof IBancDeMedicamentRecipe)) continue;
            adaptedRecipes.add((IBancDeMedicamentRecipe)recipe);
            LOGGER.debug("Added existing IBancDeMedicamentRecipe: {}", (Object)recipe.func_77571_b().func_82833_r());
        }
        initialized = true;
        LOGGER.info("BancDeMedicamentRecipeManager initialized with {} recipes", (Object)adaptedRecipes.size());
    }

    public static List<IBancDeMedicamentRecipe> getAllRecipes() {
        if (!initialized) {
            BancDeMedicamentRecipeManager.initialize();
        }
        return adaptedRecipes;
    }

    public static void registerRecipe(IBancDeMedicamentRecipe recipe) {
        if (!initialized) {
            BancDeMedicamentRecipeManager.initialize();
        }
        for (IBancDeMedicamentRecipe existing : adaptedRecipes) {
            if (!existing.getRecipeOutput().func_77969_a(recipe.getRecipeOutput())) continue;
            LOGGER.warn("Recipe already registered for output: {}", (Object)recipe.getRecipeOutput().func_82833_r());
            return;
        }
        adaptedRecipes.add(recipe);
        LOGGER.debug("Registered new BancDeMedicament recipe: {}", (Object)recipe.getRecipeOutput().func_82833_r());
    }
}

