/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.cook.plandetravail.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fr.minepiece.common.blocks.jobs.crafting.cook.plandetravail.recipes.IPlanDeTravailRecipe;
import fr.minepiece.common.craft.CraftingResult;
import fr.minepiece.common.craft.IMinePieceCraftingInventory;
import fr.minepiece.common.init.ModTools;
import fr.minepiece.common.items.jobs.cook.CookToolItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapedPlanDeTravailRecipe
extends ShapedOreRecipe
implements IPlanDeTravailRecipe {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Recipes");
    private static final int MAX_GRID_WIDTH = 6;
    private static final int MAX_GRID_HEIGHT = 6;
    private final int recipeWidth;
    private final int recipeHeight;
    private final int levelRequired;
    private final int xpReward;
    private final NonNullList<Ingredient> input;
    private final ResourceLocation recipeId;
    private final boolean[] specialSlotUsage;
    private final Ingredient[] specialSlotIngredients;

    public ShapedPlanDeTravailRecipe(ResourceLocation group, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer, int levelRequired, int xpReward, boolean[] specialSlotUsage, Ingredient[] specialSlotIngredients) {
        super(group, result, primer);
        this.recipeWidth = primer.width;
        this.recipeHeight = primer.height;
        this.levelRequired = levelRequired;
        this.xpReward = xpReward;
        this.input = primer.input;
        this.recipeId = group;
        this.specialSlotUsage = specialSlotUsage;
        this.specialSlotIngredients = specialSlotIngredients;
        LOGGER.debug("Created ShapedPlanDeTravailRecipe: {}x{}, result: {}, level: {}, xp: {}", (Object)this.recipeWidth, (Object)this.recipeHeight, (Object)result.func_82833_r(), (Object)levelRequired, (Object)xpReward);
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int startX = 0; startX <= 6 - this.recipeWidth; ++startX) {
            for (int startY = 0; startY <= 6 - this.recipeHeight; ++startY) {
                if (this.checkMatch(inv, startX, startY, false)) {
                    if (!this.specialSlotUsage[0] && !this.specialSlotUsage[1]) {
                        return true;
                    }
                    if (this.checkSpecialSlots(inv)) {
                        return true;
                    }
                }
                if (!this.checkMatch(inv, startX, startY, true)) continue;
                if (!this.specialSlotUsage[0] && !this.specialSlotUsage[1]) {
                    return true;
                }
                if (!this.checkSpecialSlots(inv)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getRecipeSize() {
        return 0;
    }

    private boolean checkSpecialSlots(InventoryCrafting inv) {
        for (int i = 0; i < 2; ++i) {
            if (!this.specialSlotUsage[i]) continue;
            ItemStack specialItem = inv.func_70301_a(36 + i);
            if (specialItem.func_190926_b()) {
                return false;
            }
            if (!specialItem.func_190926_b() && this.isTool(specialItem.func_77973_b())) {
                boolean toolMatches = false;
                for (ItemStack matchStack : this.specialSlotIngredients[i].func_193365_a()) {
                    if (specialItem.func_77973_b() != matchStack.func_77973_b()) continue;
                    toolMatches = true;
                    break;
                }
                if (toolMatches) continue;
                return false;
            }
            if (this.specialSlotIngredients[i].apply(specialItem)) continue;
            return false;
        }
        return true;
    }

    public boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirrored) {
        for (int x = 0; x < 6; ++x) {
            for (int y = 0; y < 6; ++y) {
                int invIndex;
                if (x >= startX && x < startX + this.recipeWidth && y >= startY && y < startY + this.recipeHeight || (invIndex = y * 6 + x) >= 36 || inv.func_70301_a(invIndex).func_190926_b()) continue;
                return false;
            }
        }
        for (int y = 0; y < this.recipeHeight; ++y) {
            for (int x = 0; x < this.recipeWidth; ++x) {
                int invIndex;
                int invX = startX + x;
                int invY = startY + y;
                if (invX >= 6 || invY >= 6 || (invIndex = invY * 6 + invX) >= 36) continue;
                Ingredient expectedIngredient = mirrored ? (Ingredient)this.input.get(this.recipeWidth - x - 1 + y * this.recipeWidth) : (Ingredient)this.input.get(x + y * this.recipeWidth);
                ItemStack stack = inv.func_70301_a(invIndex);
                if (expectedIngredient == Ingredient.field_193370_a) {
                    if (stack.func_190926_b()) continue;
                    return false;
                }
                if (!stack.func_190926_b() && this.isTool(stack.func_77973_b())) {
                    boolean toolMatches = false;
                    for (ItemStack matchStack : expectedIngredient.func_193365_a()) {
                        if (stack.func_77973_b() != matchStack.func_77973_b()) continue;
                        toolMatches = true;
                        break;
                    }
                    if (toolMatches) continue;
                    return false;
                }
                if (expectedIngredient.apply(stack)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public CraftingResult getCraftingResult(IMinePieceCraftingInventory inventory) {
        if (!(inventory instanceof InventoryCrafting)) {
            return new CraftingResult(ItemStack.field_190927_a, 0, new ArrayList<CraftingResult.ItemPosition>());
        }
        InventoryCrafting craftMatrix = (InventoryCrafting)inventory;
        if (!this.func_77569_a(craftMatrix, inventory.getWorld())) {
            return new CraftingResult(ItemStack.field_190927_a, 0, new ArrayList<CraftingResult.ItemPosition>());
        }
        HashMap<Integer, ItemStack> usedIngredients = new HashMap<Integer, ItemStack>();
        HashMap<Integer, ItemStack> toolSlots = new HashMap<Integer, ItemStack>();
        boolean[] used = new boolean[36];
        block0: for (int startX = 0; startX <= 6 - this.recipeWidth; ++startX) {
            for (int startY = 0; startY <= 6 - this.recipeHeight; ++startY) {
                boolean found = false;
                boolean mirrored = false;
                if (this.checkMatch(craftMatrix, startX, startY, false)) {
                    found = true;
                    mirrored = false;
                } else if (this.checkMatch(craftMatrix, startX, startY, true)) {
                    found = true;
                    mirrored = true;
                }
                if (!found) continue;
                for (int y = 0; y < this.recipeHeight; ++y) {
                    for (int x = 0; x < this.recipeWidth; ++x) {
                        ItemStack stack;
                        int invIndex;
                        int patternIndex;
                        int n = patternIndex = mirrored ? this.recipeWidth - x - 1 + y * this.recipeWidth : x + y * this.recipeWidth;
                        if (this.input.get(patternIndex) == Ingredient.field_193370_a || (invIndex = (startY + y) * 6 + (startX + x)) >= 36 || (stack = craftMatrix.func_70301_a(invIndex)).func_190926_b()) continue;
                        if (this.isTool(stack.func_77973_b())) {
                            toolSlots.put(invIndex, stack);
                        } else {
                            usedIngredients.put(invIndex, stack);
                        }
                        used[invIndex] = true;
                    }
                }
                break block0;
            }
        }
        for (int i = 0; i < 2; ++i) {
            int slotIndex;
            ItemStack stack;
            if (!this.specialSlotUsage[i] || (stack = craftMatrix.func_70301_a(slotIndex = 36 + i)).func_190926_b()) continue;
            if (this.isTool(stack.func_77973_b())) {
                toolSlots.put(slotIndex, stack);
                continue;
            }
            usedIngredients.put(slotIndex, stack);
        }
        int minMultiplier = Integer.MAX_VALUE;
        for (Map.Entry entry : usedIngredients.entrySet()) {
            ItemStack stack = (ItemStack)entry.getValue();
            minMultiplier = Math.min(minMultiplier, stack.func_190916_E());
        }
        if (minMultiplier == Integer.MAX_VALUE || minMultiplier <= 0) {
            minMultiplier = 1;
        }
        ArrayList<CraftingResult.ItemPosition> consumedItems = new ArrayList<CraftingResult.ItemPosition>();
        for (Map.Entry entry : usedIngredients.entrySet()) {
            consumedItems.add(new CraftingResult.ItemPosition((Integer)entry.getKey(), minMultiplier));
        }
        for (Map.Entry entry : toolSlots.entrySet()) {
            consumedItems.add(new CraftingResult.ItemPosition((Integer)entry.getKey(), 0));
        }
        ItemStack craftedResult = this.func_77571_b().func_77946_l();
        craftedResult.func_190920_e(craftedResult.func_190916_E() * minMultiplier);
        return new CraftingResult(craftedResult, minMultiplier, consumedItems);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.func_77571_b().func_77946_l();
    }

    @Override
    public boolean matches(IMinePieceCraftingInventory inventory, World world) {
        return false;
    }

    @Override
    public int getLevelRequired() {
        return this.levelRequired;
    }

    @Override
    public int getXpReward() {
        return this.xpReward;
    }

    @Override
    public boolean usesSpecialSlot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.specialSlotUsage.length) {
            return false;
        }
        return this.specialSlotUsage[slotIndex];
    }

    private boolean isTool(Item item) {
        return item == ModTools.COUTEAU_CUISINE || item == ModTools.EMINCEUR || item == ModTools.FILET_DE_SOLE || item == ModTools.BOL_CUISINE || item instanceof CookToolItem;
    }

    public String toString() {
        return "ShapedPlanDeTravailRecipe{output=" + this.func_77571_b().func_82833_r() + ", recipeId=" + this.recipeId + ", levelRequired=" + this.levelRequired + ", xpReward=" + this.xpReward + '}';
    }

    public static class RecipeFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            try {
                HashMap<Character, Ingredient> ingredientMap = new HashMap<Character, Ingredient>();
                for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
                    if (((String)entry.getKey()).length() != 1) {
                        throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                    }
                    if (" ".equals(entry.getKey())) {
                        throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                    }
                    ingredientMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
                }
                ingredientMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
                JsonArray pattern = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
                if (pattern.size() == 0) {
                    throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
                }
                if (pattern.size() > 6) {
                    throw new JsonSyntaxException("Invalid pattern: too many rows, 6 is maximum");
                }
                String[] rows = new String[pattern.size()];
                for (int i = 0; i < rows.length; ++i) {
                    String row = JsonUtils.func_151206_a((JsonElement)pattern.get(i), (String)("pattern[" + i + "]"));
                    if (row.length() > 6) {
                        throw new JsonSyntaxException("Invalid pattern: too many columns, 6 is maximum");
                    }
                    rows[i] = row;
                }
                int width = rows[0].length();
                int height = rows.length;
                NonNullList ingredients = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
                HashSet keys = new HashSet(ingredientMap.keySet());
                keys.remove(Character.valueOf(' '));
                for (int y = 0; y < height; ++y) {
                    String row = rows[y];
                    for (int x = 0; x < row.length(); ++x) {
                        char c = row.charAt(x);
                        Ingredient ingredient = (Ingredient)ingredientMap.get(Character.valueOf(c));
                        if (ingredient == null) {
                            throw new JsonSyntaxException("Pattern references symbol '" + c + "' but it's not defined in the key");
                        }
                        ingredients.set(x + y * width, (Object)ingredient);
                        keys.remove(Character.valueOf(c));
                    }
                }
                if (!keys.isEmpty()) {
                    throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
                }
                boolean[] specialSlotUsage = new boolean[2];
                Ingredient[] specialSlotIngredients = new Ingredient[2];
                if (json.has("special_slots")) {
                    JsonObject specialSlots = JsonUtils.func_152754_s((JsonObject)json, (String)"special_slots");
                    if (specialSlots.has("slot1")) {
                        specialSlotUsage[0] = true;
                        specialSlotIngredients[0] = CraftingHelper.getIngredient((JsonElement)specialSlots.get("slot1"), (JsonContext)context);
                    }
                    if (specialSlots.has("slot2")) {
                        specialSlotUsage[1] = true;
                        specialSlotIngredients[1] = CraftingHelper.getIngredient((JsonElement)specialSlots.get("slot2"), (JsonContext)context);
                    }
                }
                JsonObject resultJson = JsonUtils.func_152754_s((JsonObject)json, (String)"result");
                ItemStack result = CraftingHelper.getItemStack((JsonObject)resultJson, (JsonContext)context);
                if (resultJson.has("nbt")) {
                    try {
                        String nbtString = resultJson.get("nbt").getAsString();
                        NBTTagCompound nbt = JsonToNBT.func_180713_a((String)nbtString);
                        result.func_77982_d(nbt);
                    }
                    catch (NBTException e) {
                        throw new JsonSyntaxException("Invalid NBT for recipe result: " + e.getMessage());
                    }
                }
                int levelRequired = JsonUtils.func_151208_a((JsonObject)json, (String)"level_required", (int)1);
                int xpReward = JsonUtils.func_151208_a((JsonObject)json, (String)"xp_reward", (int)0);
                CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
                primer.width = width;
                primer.height = height;
                primer.mirrored = false;
                primer.input = ingredients;
                return new ShapedPlanDeTravailRecipe(group.isEmpty() ? null : new ResourceLocation(group), result, primer, levelRequired, xpReward, specialSlotUsage, specialSlotIngredients);
            }
            catch (Exception e) {
                LOGGER.error("Error parsing recipe: {}", (Object)e.getMessage());
                throw e;
            }
        }
    }
}

