/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.cook.plancheadecouper.recipes;

import com.google.common.collect.Maps;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.init.ModFoods;
import fr.minepiece.common.init.ModTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PlancheADecouperRecipes {
    private static final PlancheADecouperRecipes INSTANCE = new PlancheADecouperRecipes();
    private final List<Recipe> recipes = new ArrayList<Recipe>();

    public static PlancheADecouperRecipes getInstance() {
        return INSTANCE;
    }

    private PlancheADecouperRecipes() {
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.TOMATE), new ItemStack(ModFoods.RONDELLES_TOMATE, 6), 2, 2.0f, ModTools.COUTEAU_CUISINE);
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.PAIN), new ItemStack(ModFoods.PAIN_COUPE, 2), 2, 4.0f, ModTools.COUTEAU_CUISINE);
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.SALADE), new ItemStack(ModFoods.FEUILLE_SALADE, 6), 2, 3.0f, ModTools.COUTEAU_CUISINE);
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.RONDELLES_TOMATE), new ItemStack(ModFoods.GASPACHO), 2, 11.0f, ModTools.BOL_CUISINE);
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.OIGNON), new ItemStack(ModFoods.OIGNON_EMINCE, 12), 3, 12.0f, ModTools.EMINCEUR);
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.CAROTTE), new ItemStack(ModFoods.RONDELLE_CAROTTE, 8), 4, 5.0f, ModTools.COUTEAU_CUISINE);
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.POMME), new ItemStack(ModFoods.MORCEAU_POMME, 8), 4, 4.0f, ModTools.COUTEAU_CUISINE);
        this.addPlancheADecouperRecipe(new ItemStack(Items.field_151120_aE), new ItemStack(ModFoods.SUCRE_CUISINE, 2), 4, 5.0f, ModTools.COUTEAU_CUISINE);
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.PATATE), new ItemStack(ModFoods.FRITES_CRUES, 5), 5, 6.0f, ModTools.COUTEAU_CUISINE);
        this.addPlancheADecouperRecipe(new ItemStack(Items.field_151115_aP), new ItemStack(ModFoods.FILET_POISSON, 2), 5, 6.0f, ModTools.FILET_DE_SOLE);
        this.addPlancheADecouperRecipe(new ItemStack(Items.field_151076_bf), new ItemStack(ModFoods.BLANC_POULET, 2), 5, 4.0f, ModTools.COUTEAU_CUISINE);
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.POIVRON), new ItemStack(ModFoods.POIVRON_EMINCE, 3), 5, 3.0f, ModTools.EMINCEUR);
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.BANANE), new ItemStack(ModFoods.RONDELLES_BANANE, 6), 6, 5.0f, ModTools.COUTEAU_CUISINE);
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.KIWI), new ItemStack(ModFoods.RONDELLES_KIWI, 6), 6, 5.0f, ModTools.COUTEAU_CUISINE);
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.PATATE), new ItemStack(ModFoods.POMME_TERRE_EMINCE, 6), 6, 4.0f, ModTools.EMINCEUR);
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.CITRON), new ItemStack(ModFoods.RONDELLE_CITRON, 5), 6, 5.0f, ModTools.COUTEAU_CUISINE);
        this.addPlancheADecouperRecipe(new ItemStack(Items.field_151147_al), new ItemStack(ModFoods.LARD, 2), 8, 9.0f, ModTools.COUTEAU_CUISINE);
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.COURGETTE), new ItemStack(ModFoods.RONDELLE_COURGETTE, 8), 8, 8.0f, ModTools.COUTEAU_CUISINE);
        this.addPlancheADecouperRecipe(new ItemStack(ModFoods.AUBERGINE), new ItemStack(ModFoods.RONDELLE_AUBERGINE, 5), 8, 8.0f, ModTools.COUTEAU_CUISINE);
    }

    public void addPlancheADecouperRecipe(ItemStack input, ItemStack result, int levelRequired, float experience, Item requiredTool) {
        this.recipes.add(new Recipe(input, result, levelRequired, experience, requiredTool));
    }

    public ItemStack getPlancheADecouperResultWithTool(ItemStack input, ItemStack tool) {
        if (tool.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (Recipe recipe : this.recipes) {
            if (!this.compareItemStacks(input, recipe.input) || tool.func_77973_b() != recipe.requiredTool) continue;
            return recipe.output.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getPlancheADecouperResult(ItemStack input) {
        for (Recipe recipe : this.recipes) {
            if (!this.compareItemStacks(input, recipe.input)) continue;
            return recipe.output.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public List<Item> getRequiredToolsForInput(ItemStack input) {
        ArrayList<Item> tools = new ArrayList<Item>();
        for (Recipe recipe : this.recipes) {
            if (!this.compareItemStacks(input, recipe.input)) continue;
            tools.add(recipe.requiredTool);
        }
        return tools;
    }

    public Item getRequiredTool(ItemStack input) {
        List<Item> tools = this.getRequiredToolsForInput(input);
        return tools.isEmpty() ? null : tools.get(0);
    }

    public boolean isToolValidForInput(ItemStack input, ItemStack tool) {
        if (tool.func_190926_b()) {
            return false;
        }
        for (Recipe recipe : this.recipes) {
            if (!this.compareItemStacks(input, recipe.input) || tool.func_77973_b() != recipe.requiredTool) continue;
            return true;
        }
        return false;
    }

    public ItemStack getPlancheADecouperResult(ItemStack input, ItemStack tool, EntityPlayer player) {
        for (Recipe recipe : this.recipes) {
            if (!this.compareItemStacks(input, recipe.input) || tool.func_77973_b() != recipe.requiredTool) continue;
            if (player != null && player.hasCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) {
                IMinePieceData mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
                if (mpData != null && mpData.getJobLevel() >= recipe.levelRequired) {
                    return recipe.output.func_77946_l();
                }
                return ItemStack.field_190927_a;
            }
            return recipe.output.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getPlancheADecouperResult(ItemStack input, EntityPlayer player) {
        for (Recipe recipe : this.recipes) {
            if (!this.compareItemStacks(input, recipe.input)) continue;
            if (player != null && player.hasCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) {
                IMinePieceData mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
                if (mpData != null && mpData.getJobLevel() >= recipe.levelRequired) {
                    return recipe.output.func_77946_l();
                }
                return ItemStack.field_190927_a;
            }
            return recipe.output.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public int getLevelRequirement(ItemStack input, ItemStack tool) {
        for (Recipe recipe : this.recipes) {
            if (!this.compareItemStacks(input, recipe.input) || tool.func_77973_b() != recipe.requiredTool) continue;
            return recipe.levelRequired;
        }
        return 1;
    }

    public int getLevelRequirement(ItemStack input) {
        for (Recipe recipe : this.recipes) {
            if (!this.compareItemStacks(input, recipe.input)) continue;
            return recipe.levelRequired;
        }
        return 1;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public List<Recipe> getAllRecipes() {
        return this.recipes;
    }

    public Map<ItemStack, ItemStack> getDualDecoupingList() {
        HashMap map = Maps.newHashMap();
        for (Recipe recipe : this.recipes) {
            map.put(recipe.input, recipe.output);
        }
        return map;
    }

    public float getPlancheADecouperExperience(ItemStack output) {
        for (Recipe recipe : this.recipes) {
            if (!this.compareItemStacks(output, recipe.output)) continue;
            return recipe.experience;
        }
        return 0.0f;
    }

    private static class Recipe {
        ItemStack input;
        ItemStack output;
        int levelRequired;
        float experience;
        Item requiredTool;

        Recipe(ItemStack input, ItemStack output, int levelRequired, float experience, Item requiredTool) {
            this.input = input;
            this.output = output;
            this.levelRequired = levelRequired;
            this.experience = experience;
            this.requiredTool = requiredTool;
        }
    }
}

