/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.cook.fut.tileentity;

import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.blocks.jobs.crafting.cook.fut.BlockFut;
import fr.minepiece.common.blocks.jobs.crafting.cook.fut.recipes.FutRecipes;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.init.ModItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFut
extends TileEntity
implements IInventory,
ITickable {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    private String customName;
    private int fermentationTime;
    private int currentFermentationTime;
    private int cookTime;
    private int totalCookTime;
    private final Map<FutRecipes.RecipeKey, Integer> levelRequirements = new HashMap<FutRecipes.RecipeKey, Integer>();

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.fut";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index >= 0 && index <= 3 || index == 4) {
            this.totalCookTime = this.getCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.fermentationTime = compound.func_74762_e("FermentationTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("TotalCookTime");
        this.currentFermentationTime = TileEntityFut.getItemFermentationTime((ItemStack)this.inventory.get(4));
        if (compound.func_150297_b("CustomName", 8)) {
            this.setCustomName(compound.func_74779_i("CustomName"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("FermentationTime", this.fermentationTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("TotalCookTime", this.totalCookTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isFermenting() {
        return this.fermentationTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isFermenting(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isFermenting();
        boolean flag1 = false;
        if (this.isFermenting()) {
            --this.fermentationTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack result;
            boolean hasAllIngredients = this.hasRequiredIngredients();
            ItemStack water = (ItemStack)this.inventory.get(4);
            if (hasAllIngredients && !this.isFermenting() && !(result = this.getRecipeResult()).func_190926_b() && !water.func_190926_b() && TileEntityFut.isItemFuel(water)) {
                this.currentFermentationTime = this.fermentationTime = TileEntityFut.getItemFermentationTime(water);
                water.func_190918_g(1);
                flag1 = true;
                this.func_70296_d();
            }
            if (this.isFermenting() && this.canFermentItem()) {
                ++this.cookTime;
                if (this.cookTime >= this.totalCookTime) {
                    this.cookTime = 0;
                    this.fermentItem();
                    flag1 = true;
                }
            } else {
                this.cookTime = 0;
            }
            if (flag != this.isFermenting()) {
                flag1 = true;
                BlockFut.setState(this.isFermenting(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getCookTime() {
        return 9600;
    }

    private boolean hasRequiredIngredients() {
        boolean hasIngredients = true;
        for (int i = 0; i < 4; ++i) {
            if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            hasIngredients = false;
            break;
        }
        return hasIngredients;
    }

    private ItemStack getRecipeResult() {
        ItemStack[] ingredients = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            ingredients[i] = (ItemStack)this.inventory.get(i);
        }
        return FutRecipes.getInstance().getFutResult(ingredients);
    }

    private boolean canFermentItem() {
        if (!this.hasRequiredIngredients()) {
            return false;
        }
        ItemStack result = this.getRecipeResult();
        if (result.func_190926_b()) {
            return false;
        }
        ItemStack output = (ItemStack)this.inventory.get(5);
        if (output.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(result)) {
            return false;
        }
        int res = output.func_190916_E() + result.func_190916_E();
        return res <= this.func_70297_j_() && res <= output.func_77976_d();
    }

    public void fermentItem() {
        if (this.canFermentItem()) {
            IMinePieceData mpData;
            ItemStack result = this.getRecipeResult();
            ItemStack output = (ItemStack)this.inventory.get(5);
            if (output.func_190926_b()) {
                this.inventory.set(5, (Object)result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }
            EntityPlayer player = this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0, false);
            if (player != null && player instanceof EntityPlayerMP && (mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) != null) {
                float experience = FutRecipes.getInstance().getFutExperience(result);
                PlayerUtils.addJobXpToPlayer((EntityPlayerMP)player, (int)experience);
                mpData.clientSync((EntityPlayerMP)player);
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7aFermentation r\u00e9ussie ! \u00a76+" + (int)experience + " XP"));
                if (mpData.getDailyCraftLimit() > 0) {
                    mpData.setDailyCraftLimit(mpData.getDailyCraftLimit() - 1);
                    mpData.clientSync((EntityPlayerMP)player);
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7aCraft journalier restant : \u00a76" + mpData.getDailyCraftLimit()));
                }
            }
            for (int i = 0; i < 4; ++i) {
                ((ItemStack)this.inventory.get(i)).func_190918_g(1);
            }
        }
    }

    public static int getItemFermentationTime(ItemStack stack) {
        if (!TileEntityFut.isItemFuel(stack)) {
            return 0;
        }
        return 9600;
    }

    public static boolean isItemFuel(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b() == ModItems.FIOLE_VIDE;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 5) {
            return false;
        }
        if (index == 4) {
            return TileEntityFut.isItemFuel(stack);
        }
        return true;
    }

    public String getGuiID() {
        return "minepiece:fut";
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.fermentationTime;
            }
            case 1: {
                return this.currentFermentationTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.fermentationTime = value;
                break;
            }
            case 1: {
                this.currentFermentationTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }
}

