/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.cook.fut.recipes;

import com.google.common.collect.Maps;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.init.ModBeverages;
import fr.minepiece.common.init.ModFoods;
import fr.minepiece.common.init.ModItems;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class FutRecipes {
    private static final FutRecipes INSTANCE = new FutRecipes();
    private final Map<RecipeKey, ItemStack> fermentingList = Maps.newHashMap();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();
    private final Map<RecipeKey, Integer> levelRequirements = Maps.newHashMap();

    public static FutRecipes getInstance() {
        return INSTANCE;
    }

    private FutRecipes() {
        this.addFutRecipe(new ItemStack[]{new ItemStack(ModFoods.SUCRE_CUISINE), new ItemStack(ModItems.POLLEN_LUPIN), new ItemStack(ModItems.POLLEN_ROSE_ROUGE), new ItemStack(ModFoods.RONDELLE_CITRON)}, new ItemStack(ModBeverages.COLA), 7, 18.0f);
        this.addFutRecipe(new ItemStack[]{new ItemStack(ModFoods.RAISIN), new ItemStack(ModFoods.RAISIN), new ItemStack(ModFoods.RAISIN), new ItemStack(ModFoods.RAISIN)}, new ItemStack(ModBeverages.BOUTEILLE_VIN_ROUGE), 10, 19.0f);
    }

    public void addFutRecipe(ItemStack[] ingredients, ItemStack result, int levelRequired, float experience) {
        if (ingredients.length != 4) {
            throw new IllegalArgumentException("La recette de fermentation doit avoir exactement 4 ingr\u00e9dients");
        }
        RecipeKey key = new RecipeKey(ingredients);
        if (this.getFutResult(ingredients) != ItemStack.field_190927_a) {
            return;
        }
        this.fermentingList.put(key, result);
        this.experienceList.put(result, Float.valueOf(experience));
        this.levelRequirements.put(key, levelRequired);
    }

    public ItemStack getFutResult(ItemStack[] ingredients) {
        if (ingredients.length != 4) {
            return ItemStack.field_190927_a;
        }
        RecipeKey key = new RecipeKey(ingredients);
        for (Map.Entry<RecipeKey, ItemStack> entry : this.fermentingList.entrySet()) {
            if (!this.compareRecipes(key, entry.getKey())) continue;
            return entry.getValue().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getFutResult(ItemStack[] ingredients, EntityPlayer player) {
        if (ingredients.length != 4) {
            return ItemStack.field_190927_a;
        }
        RecipeKey key = new RecipeKey(ingredients);
        for (Map.Entry<RecipeKey, ItemStack> entry : this.fermentingList.entrySet()) {
            if (!this.compareRecipes(key, entry.getKey())) continue;
            if (player != null && player.hasCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) {
                IMinePieceData mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
                int requiredLevel = this.getLevelRequirement(ingredients);
                if (mpData != null && mpData.getJobLevel() >= requiredLevel) {
                    return entry.getValue().func_77946_l();
                }
                return ItemStack.field_190927_a;
            }
            return entry.getValue().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public int getLevelRequirement(ItemStack[] ingredients) {
        if (ingredients.length != 4) {
            return 1;
        }
        RecipeKey key = new RecipeKey(ingredients);
        for (Map.Entry<RecipeKey, Integer> entry : this.levelRequirements.entrySet()) {
            if (!this.compareRecipes(key, entry.getKey())) continue;
            return entry.getValue();
        }
        return 1;
    }

    private boolean compareRecipes(RecipeKey recipe1, RecipeKey recipe2) {
        ItemStack[] ingredients1 = recipe1.getIngredients();
        ItemStack[] ingredients2 = recipe2.getIngredients();
        for (ItemStack ingredient1 : ingredients1) {
            boolean found = false;
            for (ItemStack ingredient2 : ingredients2) {
                if (!this.compareItemStacks(ingredient1, ingredient2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<RecipeKey, ItemStack> getFermentingList() {
        return this.fermentingList;
    }

    public float getFutExperience(ItemStack stack) {
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }

    public static class RecipeKey {
        private final ItemStack[] ingredients;

        public RecipeKey(ItemStack[] ingredients) {
            this.ingredients = ingredients;
        }

        public ItemStack[] getIngredients() {
            return this.ingredients;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecipeKey recipeKey = (RecipeKey)o;
            return Arrays.equals(this.ingredients, recipeKey.ingredients);
        }

        public int hashCode() {
            return Arrays.hashCode(this.ingredients);
        }
    }
}

