/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.cook.chaudron.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import fr.minepiece.common.blocks.jobs.crafting.cook.chaudron.recipes.IChaudronRecipe;
import fr.minepiece.common.craft.CraftingResult;
import fr.minepiece.common.craft.IMinePieceCraftingInventory;
import fr.minepiece.common.init.ModTools;
import fr.minepiece.common.items.jobs.cook.CookToolItem;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapelessChaudronRecipe
extends ShapelessOreRecipe
implements IChaudronRecipe {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Recipes");
    private final int levelRequired;
    private final int xpReward;
    private final int cookingTime;

    public ShapelessChaudronRecipe(ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result, int levelRequired, int xpReward, int cookingTime) {
        super(group, input, result);
        this.levelRequired = levelRequired;
        this.xpReward = xpReward;
        this.cookingTime = cookingTime;
        LOGGER.debug("Creating new ShapelessChaudronRecipe:");
        LOGGER.debug(" - Group: {}", (Object)group);
        LOGGER.debug(" - Result: {}", (Object)result.func_82833_r());
        LOGGER.debug(" - Level Required: {}", (Object)levelRequired);
        LOGGER.debug(" - XP Reward: {}", (Object)xpReward);
        LOGGER.debug(" - Cooking Time: {}", (Object)cookingTime);
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        ArrayList ingredients = new ArrayList(this.func_192400_c());
        if (ingredients.isEmpty()) {
            return false;
        }
        ArrayList<Integer> filledSlots = new ArrayList<Integer>();
        for (int i = 0; i < 8; ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            filledSlots.add(i);
        }
        if (filledSlots.size() != ingredients.size()) {
            return false;
        }
        for (Ingredient ingredient : ingredients) {
            boolean found = false;
            Iterator slotIterator = filledSlots.iterator();
            while (slotIterator.hasNext()) {
                int slotIndex = (Integer)slotIterator.next();
                ItemStack stackInSlot = inv.func_70301_a(slotIndex);
                if (!ingredient.apply(stackInSlot)) continue;
                slotIterator.remove();
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return filledSlots.isEmpty();
    }

    @Override
    public CraftingResult getCraftingResult(IMinePieceCraftingInventory inventory) {
        if (!(inventory instanceof InventoryCrafting)) {
            return new CraftingResult(ItemStack.field_190927_a, 0, new ArrayList<CraftingResult.ItemPosition>());
        }
        InventoryCrafting craftMatrix = (InventoryCrafting)inventory;
        if (!this.func_77569_a(craftMatrix, inventory.getWorld())) {
            return new CraftingResult(ItemStack.field_190927_a, 0, new ArrayList<CraftingResult.ItemPosition>());
        }
        ArrayList<Integer> usedSlots = new ArrayList<Integer>();
        for (int i = 0; i < 8; ++i) {
            if (craftMatrix.func_70301_a(i).func_190926_b()) continue;
            usedSlots.add(i);
        }
        int minMultiplier = Integer.MAX_VALUE;
        ArrayList<CraftingResult.ItemPosition> consumedItems = new ArrayList<CraftingResult.ItemPosition>();
        Iterator iterator = usedSlots.iterator();
        while (iterator.hasNext()) {
            int slotIndex = (Integer)iterator.next();
            ItemStack stack = craftMatrix.func_70301_a(slotIndex);
            if (stack.func_190926_b()) continue;
            if (!this.isTool(stack.func_77973_b())) {
                minMultiplier = Math.min(minMultiplier, stack.func_190916_E());
                consumedItems.add(new CraftingResult.ItemPosition(slotIndex, 1));
                continue;
            }
            consumedItems.add(new CraftingResult.ItemPosition(slotIndex, 0));
        }
        if (minMultiplier == Integer.MAX_VALUE || minMultiplier <= 0) {
            minMultiplier = 1;
        }
        ItemStack result = this.func_77571_b().func_77946_l();
        result.func_190920_e(result.func_190916_E() * minMultiplier);
        return new CraftingResult(result, minMultiplier, consumedItems);
    }

    @Override
    public int getRecipeSize() {
        return this.func_192400_c().size();
    }

    @Override
    public int getLevelRequired() {
        return this.levelRequired;
    }

    @Override
    public int getXpReward() {
        return this.xpReward;
    }

    @Override
    public int getCookingTime() {
        return this.cookingTime;
    }

    private boolean isTool(Item item) {
        return item == ModTools.BOL_CUISINE || item == ModTools.EMINCEUR || item == ModTools.COUTEAU_CUISINE || item instanceof CookToolItem;
    }

    public static class RecipeFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            LOGGER.debug("Parsing shapeless recipe JSON: {}", (Object)json);
            try {
                NonNullList ingredients = NonNullList.func_191196_a();
                for (JsonElement element : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                    ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element, (JsonContext)context));
                }
                if (ingredients.isEmpty()) {
                    throw new JsonParseException("No ingredients for shapeless recipe");
                }
                ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
                int levelRequired = JsonUtils.func_151208_a((JsonObject)json, (String)"level_required", (int)1);
                int xpReward = JsonUtils.func_151208_a((JsonObject)json, (String)"xp_reward", (int)0);
                int cookingTime = JsonUtils.func_151208_a((JsonObject)json, (String)"cooking_time", (int)600);
                return new ShapelessChaudronRecipe(group.isEmpty() ? null : new ResourceLocation(group), (NonNullList<Ingredient>)ingredients, result, levelRequired, xpReward, cookingTime);
            }
            catch (Exception e) {
                LOGGER.error("Error parsing shapeless recipe: {}", (Object)e.getMessage());
                LOGGER.error("Recipe JSON: {}", (Object)json);
                e.printStackTrace();
                throw e;
            }
        }
    }
}

