/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.cook.chaudron.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.blocks.jobs.crafting.cook.chaudron.recipes.IChaudronRecipe;
import fr.minepiece.common.craft.AbstractShapedMinePieceRecipe;
import fr.minepiece.common.craft.CraftingResult;
import fr.minepiece.common.craft.IMinePieceCraftingInventory;
import fr.minepiece.common.init.ModTools;
import fr.minepiece.common.items.jobs.cook.CookToolItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapedChaudronRecipe
extends AbstractShapedMinePieceRecipe
implements IChaudronRecipe {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Recipes");
    private static final int GRID_WIDTH = 8;
    private static final int GRID_HEIGHT = 1;
    private final int cookingTime;
    private boolean isCircular = true;

    public ShapedChaudronRecipe(ResourceLocation group, @Nonnull ItemStack result, NonNullList<Ingredient> ingredients, int width, int height, int levelRequired, int xpReward, int cookingTime) {
        super(group, result, ingredients, width, height, levelRequired, xpReward, MinePieceJobs.COOK);
        this.cookingTime = cookingTime;
        LOGGER.debug("Creating new ShapedChaudronRecipe:");
        LOGGER.debug(" - Group: {}", (Object)group);
        LOGGER.debug(" - Result: {}", (Object)result.func_82833_r());
        LOGGER.debug(" - Level Required: {}", (Object)levelRequired);
        LOGGER.debug(" - XP Reward: {}", (Object)xpReward);
        LOGGER.debug(" - Cooking Time: {}", (Object)cookingTime);
        LOGGER.debug(" - Grid size: {}x{}", (Object)width, (Object)height);
    }

    @Override
    public int getCookingTime() {
        return this.cookingTime;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        if (this.isCircular) {
            return this.checkCircularMatch(inv);
        }
        return super.func_77569_a(inv, world);
    }

    @Override
    public boolean matches(IMinePieceCraftingInventory inventory, World world) {
        if (inventory instanceof InventoryCrafting) {
            return this.func_77569_a((InventoryCrafting)inventory, world);
        }
        return false;
    }

    private boolean checkCircularMatch(InventoryCrafting inv) {
        int i;
        int[] circularIndices = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        for (i = 0; i < circularIndices.length; ++i) {
            int slotIndex = circularIndices[i];
            if (i >= this.ingredients.size()) continue;
            Ingredient expected = (Ingredient)this.ingredients.get(i);
            ItemStack slotStack = inv.func_70301_a(slotIndex);
            if (!(expected == Ingredient.field_193370_a ? !slotStack.func_190926_b() : !expected.apply(slotStack))) continue;
            return false;
        }
        for (i = 0; i < inv.func_70302_i_(); ++i) {
            if (this.contains(circularIndices, i) || inv.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private boolean contains(int[] array, int value) {
        for (int i : array) {
            if (i != value) continue;
            return true;
        }
        return false;
    }

    @Override
    public CraftingResult getCraftingResult(IMinePieceCraftingInventory inventory) {
        if (!(inventory instanceof InventoryCrafting)) {
            return new CraftingResult(ItemStack.field_190927_a, 0, new ArrayList<CraftingResult.ItemPosition>());
        }
        InventoryCrafting craftMatrix = (InventoryCrafting)inventory;
        if (!this.func_77569_a(craftMatrix, inventory.getWorld())) {
            return new CraftingResult(ItemStack.field_190927_a, 0, new ArrayList<CraftingResult.ItemPosition>());
        }
        int[] circularIndices = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
        ArrayList<CraftingResult.ItemPosition> consumedItems = new ArrayList<CraftingResult.ItemPosition>();
        int minMultiplier = Integer.MAX_VALUE;
        for (int i = 0; i < circularIndices.length; ++i) {
            int slotIndex = circularIndices[i];
            if (i >= this.ingredients.size()) continue;
            Ingredient expected = (Ingredient)this.ingredients.get(i);
            ItemStack slotStack = craftMatrix.func_70301_a(slotIndex);
            if (expected == Ingredient.field_193370_a || slotStack.func_190926_b()) continue;
            if (!this.isTool(slotStack.func_77973_b())) {
                minMultiplier = Math.min(minMultiplier, slotStack.func_190916_E());
                consumedItems.add(new CraftingResult.ItemPosition(slotIndex, 1));
                continue;
            }
            consumedItems.add(new CraftingResult.ItemPosition(slotIndex, 0));
        }
        if (minMultiplier == Integer.MAX_VALUE || minMultiplier <= 0) {
            minMultiplier = 1;
        }
        ItemStack craftedResult = this.func_77571_b().func_77946_l();
        craftedResult.func_190920_e(craftedResult.func_190916_E() * minMultiplier);
        return new CraftingResult(craftedResult, minMultiplier, consumedItems);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.func_77571_b().func_77946_l();
    }

    @Override
    public int getRecipeSize() {
        return 8;
    }

    @Override
    public int getXpReward() {
        return 0;
    }

    private boolean isTool(Item item) {
        return item == ModTools.BOL_CUISINE || item == ModTools.EMINCEUR || item == ModTools.COUTEAU_CUISINE || item instanceof CookToolItem;
    }

    public static class RecipeFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            LOGGER.debug("Parsing recipe JSON: {}", (Object)json);
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            try {
                HashMap<Character, Ingredient> ingredientMap = new HashMap<Character, Ingredient>();
                for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
                    if (((String)entry.getKey()).length() != 1) {
                        throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                    }
                    if (" ".equals(entry.getKey())) {
                        throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                    }
                    ingredientMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
                }
                ingredientMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
                JsonArray pattern = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
                if (pattern.size() != 1) {
                    throw new JsonSyntaxException("Invalid pattern: must have exactly 1 rows");
                }
                String[] rows = new String[pattern.size()];
                for (int i = 0; i < rows.length; ++i) {
                    String row = JsonUtils.func_151206_a((JsonElement)pattern.get(i), (String)("pattern[" + i + "]"));
                    if (row.length() != 8) {
                        throw new JsonSyntaxException("Invalid pattern: row " + (i + 1) + " must have exactly " + 8 + " columns");
                    }
                    rows[i] = row;
                }
                NonNullList ingredients = NonNullList.func_191197_a((int)8, (Object)Ingredient.field_193370_a);
                HashSet keys = new HashSet(ingredientMap.keySet());
                keys.remove(Character.valueOf(' '));
                int index = 0;
                for (String row : rows) {
                    for (char chr : row.toCharArray()) {
                        Ingredient ingredient = (Ingredient)ingredientMap.get(Character.valueOf(chr));
                        if (ingredient == null) {
                            throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                        }
                        ingredients.set(index++, (Object)ingredient);
                        keys.remove(Character.valueOf(chr));
                    }
                }
                if (!keys.isEmpty()) {
                    throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
                }
                ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
                int levelRequired = JsonUtils.func_151208_a((JsonObject)json, (String)"level_required", (int)1);
                int xpReward = JsonUtils.func_151208_a((JsonObject)json, (String)"xp_reward", (int)0);
                int cookingTime = JsonUtils.func_151208_a((JsonObject)json, (String)"cooking_time", (int)600);
                return new ShapedChaudronRecipe(group.isEmpty() ? null : new ResourceLocation(group), result, (NonNullList<Ingredient>)ingredients, 8, 1, levelRequired, xpReward, cookingTime);
            }
            catch (Exception e) {
                LOGGER.error("Error parsing recipe: {}", (Object)e.getMessage(), (Object)e);
                LOGGER.error("Recipe JSON: {}", (Object)json);
                throw e;
            }
        }
    }
}

