/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.cook.chaudron.container;

import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.blocks.jobs.crafting.cook.chaudron.recipes.IChaudronRecipe;
import fr.minepiece.common.blocks.jobs.crafting.cook.chaudron.slots.SlotChaudronOutput;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.init.ModTools;
import fr.minepiece.common.items.jobs.cook.CookToolItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContainerChaudron
extends Container {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Craft");
    public InventoryCrafting craftMatrix;
    public InventoryCraftResult craftResult;
    private final World world;
    private final BlockPos pos;
    private final EntityPlayer player;
    private boolean hasProcessedRecipe = false;
    private int cookingTime;
    private int cookingTimeTotal;
    private static final int DEFAULT_COOKING_TIME = 600;
    private IChaudronRecipe currentRecipe;

    public ContainerChaudron(InventoryPlayer playerInventory, World worldIn, BlockPos posIn) {
        this.world = worldIn;
        this.pos = posIn;
        this.player = playerInventory.field_70458_d;
        this.craftMatrix = new InventoryCrafting((Container)this, 3, 3);
        this.craftResult = new InventoryCraftResult();
        this.func_75146_a(new Slot((IInventory)this.craftMatrix, 0, 64, 12));
        this.func_75146_a(new Slot((IInventory)this.craftMatrix, 1, 98, 12));
        this.func_75146_a(new Slot((IInventory)this.craftMatrix, 2, 114, 33));
        this.func_75146_a(new Slot((IInventory)this.craftMatrix, 3, 114, 66));
        this.func_75146_a(new Slot((IInventory)this.craftMatrix, 4, 98, 88));
        this.func_75146_a(new Slot((IInventory)this.craftMatrix, 5, 64, 88));
        this.func_75146_a(new Slot((IInventory)this.craftMatrix, 6, 48, 66));
        this.func_75146_a(new Slot((IInventory)this.craftMatrix, 7, 48, 33));
        this.func_75146_a((Slot)new SlotChaudronOutput(playerInventory.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, 79, 47));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, 8 + col * 18, 122 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)playerInventory, col, 8 + col * 18, 180));
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.cookingTime = 0;
        this.cookingTimeTotal = 0;
        this.currentRecipe = null;
        this.hasProcessedRecipe = false;
        ItemStack resultStack = ItemStack.field_190927_a;
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            if (!(recipe instanceof IChaudronRecipe)) continue;
            IChaudronRecipe chaudronRecipe = (IChaudronRecipe)recipe;
            IMinePieceData mpData = (IMinePieceData)this.player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
            if (mpData == null || mpData.getJob() != MinePieceJobs.COOK || mpData.getJobLevel() < chaudronRecipe.getLevelRequired() || mpData.getDailyCraftLimit() <= 0 || !chaudronRecipe.matches(this.craftMatrix, this.world)) continue;
            resultStack = recipe.func_77572_b(this.craftMatrix);
            this.currentRecipe = chaudronRecipe;
            this.cookingTimeTotal = chaudronRecipe.getCookingTime();
            break;
        }
        this.craftResult.func_70299_a(0, ItemStack.field_190927_a);
        if (this.currentRecipe != null) {
            this.craftResult.func_193056_a((IRecipe)this.currentRecipe);
        } else {
            this.craftResult.func_193056_a(null);
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.currentRecipe != null && this.cookingTime < this.cookingTimeTotal) {
            ++this.cookingTime;
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 0, this.cookingTime);
                ((IContainerListener)this.field_75149_d.get(i)).func_71112_a((Container)this, 1, this.cookingTimeTotal);
            }
            if (this.cookingTime >= this.cookingTimeTotal) {
                this.craftResult.func_70299_a(0, this.currentRecipe.getCraftingResult(this.craftMatrix));
            }
        }
    }

    public void func_75137_b(int id, int data) {
        if (id == 0) {
            this.cookingTime = data;
        } else if (id == 1) {
            this.cookingTimeTotal = data;
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer playerIn) {
        if (slotId == 8 && !this.hasProcessedRecipe && !this.craftResult.func_70301_a(0).func_190926_b() && this.currentRecipe != null) {
            this.hasProcessedRecipe = true;
            this.handleCraftCompletion(this.currentRecipe);
        }
        HashMap<Integer, ItemStack> toolsBefore = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack stack = this.craftMatrix.func_70301_a(i);
            if (stack.func_190926_b() || !this.isSpecialTool(stack.func_77973_b())) continue;
            toolsBefore.put(i, stack.func_77946_l());
        }
        ItemStack result = super.func_184996_a(slotId, dragType, clickTypeIn, playerIn);
        if (slotId == 8 && !result.func_190926_b()) {
            this.restoreToolsWithDamage(toolsBefore);
        }
        return result;
    }

    private void restoreToolsWithDamage(Map<Integer, ItemStack> toolsBefore) {
        if (toolsBefore.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, ItemStack> entry : toolsBefore.entrySet()) {
            int slotIndex = entry.getKey();
            ItemStack toolStack = entry.getValue().func_77946_l();
            if (!this.craftMatrix.func_70301_a(slotIndex).func_190926_b()) continue;
            if (toolStack.func_77973_b().func_77645_m()) {
                boolean broke = false;
                if (this.player instanceof EntityPlayerMP) {
                    broke = toolStack.func_96631_a(1, this.player.func_70681_au(), (EntityPlayerMP)this.player);
                } else {
                    toolStack.func_77964_b(toolStack.func_77952_i() + 1);
                    boolean bl = broke = toolStack.func_77952_i() >= toolStack.func_77958_k();
                }
                if (broke) continue;
                this.craftMatrix.func_70299_a(slotIndex, toolStack);
                continue;
            }
            this.craftMatrix.func_70299_a(slotIndex, toolStack);
        }
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 8) {
                IRecipe recipe = this.craftResult.func_193055_i();
                HashMap<Integer, ItemStack> toolSlots = new HashMap<Integer, ItemStack>();
                for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                    ItemStack stack = this.craftMatrix.func_70301_a(i);
                    if (stack.func_190926_b() || !this.isSpecialTool(stack.func_77973_b())) continue;
                    toolSlots.put(i, stack.func_77946_l());
                    this.craftMatrix.func_70299_a(i, ItemStack.field_190927_a);
                }
                if (recipe instanceof IChaudronRecipe && !this.hasProcessedRecipe) {
                    this.hasProcessedRecipe = true;
                    this.handleCraftCompletion((IChaudronRecipe)recipe);
                }
                if (!this.func_75135_a(itemstack1, 9, 45, true)) {
                    for (Map.Entry entry : toolSlots.entrySet()) {
                        this.craftMatrix.func_70299_a(((Integer)entry.getKey()).intValue(), (ItemStack)entry.getValue());
                    }
                    return ItemStack.field_190927_a;
                }
                for (Map.Entry entry : toolSlots.entrySet()) {
                    ItemStack toolStack = (ItemStack)entry.getValue();
                    boolean broke = false;
                    if (toolStack.func_77973_b().func_77645_m() && this.player instanceof EntityPlayerMP) {
                        broke = toolStack.func_96631_a(1, this.player.func_70681_au(), (EntityPlayerMP)this.player);
                    }
                    if (broke) continue;
                    this.craftMatrix.func_70299_a(((Integer)entry.getKey()).intValue(), toolStack);
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= 0 && index < 8 ? !this.func_75135_a(itemstack1, 9, 45, false) : index >= 9 && index < 45 && !this.func_75135_a(itemstack1, 0, 8, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    private void handleCraftCompletion(IChaudronRecipe recipe) {
        if (!(this.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)this.player;
        IMinePieceData mpData = (IMinePieceData)this.player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (mpData == null) {
            return;
        }
        int xpToAdd = recipe.getXpReward();
        PlayerUtils.addJobXpToPlayer(playerMP, xpToAdd);
        int newLimit = mpData.getDailyCraftLimit() - 1;
        mpData.setDailyCraftLimit(Math.max(0, newLimit));
        mpData.clientSync(playerMP);
        this.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Craft r\u00e9ussi ! " + TextFormatting.GOLD + "+" + xpToAdd + " XP"));
        this.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Craft journalier restant : " + TextFormatting.GOLD + mpData.getDailyCraftLimit()));
    }

    private boolean isSpecialTool(Item item) {
        return item == ModTools.BOL_CUISINE || item == ModTools.EMINCEUR || item == ModTools.COUTEAU_CUISINE || item instanceof CookToolItem;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        IMinePieceData mpData = (IMinePieceData)playerIn.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        return mpData != null && mpData.getJob() == MinePieceJobs.COOK && mpData.getDailyCraftLimit() > 0 && playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.cookingTime;
            }
            case 1: {
                return this.cookingTimeTotal;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.cookingTime = value;
                break;
            }
            case 1: {
                this.cookingTimeTotal = value;
            }
        }
    }

    public int getFieldCount() {
        return 2;
    }
}

