/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.cook.chaudron;

import com.google.common.base.Predicate;
import fr.minepiece.MinePiece;
import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.blocks.BlockMinePiece;
import fr.minepiece.common.blocks.jobs.crafting.cook.chaudron.container.ContainerChaudron;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;

public class BlockChaudron
extends BlockMinePiece {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private final int requiredLevel;

    public BlockChaudron(Material material, String name, int requiredLevel) {
        super(material, name);
        this.requiredLevel = requiredLevel;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149713_g(0);
        this.func_149647_a(MinePiece.JOBS);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        IMinePieceData mpData = (IMinePieceData)playerIn.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (mpData == null) {
            return false;
        }
        if (mpData.getJob() != MinePieceJobs.COOK) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.chaudron.wrong_job", new Object[0]));
            return false;
        }
        if (mpData.getJobLevel() < this.requiredLevel) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.chaudron.level_too_low", new Object[]{this.requiredLevel}));
            return false;
        }
        if (mpData.getDailyCraftLimit() <= 0) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.chaudron.daily_limit", new Object[0]));
            return false;
        }
        playerIn.openGui((Object)MinePiece.INSTANCE, 306, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static class InterfaceChaudron
    implements IInteractionObject {
        private final World world;
        private final BlockPos position;

        public InterfaceChaudron(World worldIn, BlockPos pos) {
            this.world = worldIn;
            this.position = pos;
        }

        public String func_70005_c_() {
            return "chaudron";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation("container.chaudron", new Object[0]);
        }

        public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
            return new ContainerChaudron(playerInventory, this.world, this.position);
        }

        public String func_174875_k() {
            return "minepiece:chaudron";
        }
    }
}

