/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.blacksmith.recipes;

import fr.minepiece.common.blocks.jobs.crafting.blacksmith.atelier.recipes.IAtelierRecipe;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.atelier.recipes.ShapelessAtelierRecipe;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.forge.recipes.IForgeRecipe;
import fr.minepiece.common.init.ModTools;
import fr.minepiece.common.items.jobs.blacksmith.BlacksmithToolItem;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapelessAtelierToForgeAdapter
implements IForgeRecipe {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Recipes");
    private final ShapelessAtelierRecipe atelierRecipe;
    private static final float XP_BONUS_MULTIPLIER = 0.5f;

    public ShapelessAtelierToForgeAdapter(ShapelessAtelierRecipe atelierRecipe) {
        this.atelierRecipe = atelierRecipe;
        LOGGER.debug("Created shapeless adapter for recipe: {}", (Object)atelierRecipe.func_77571_b().func_82833_r());
    }

    @Override
    public boolean matches(InventoryCrafting craftMatrix, World world) {
        int i;
        ArrayList ingredients = new ArrayList(this.atelierRecipe.func_192400_c());
        boolean[] used = new boolean[36];
        Iterator iterator = ingredients.iterator();
        while (iterator.hasNext()) {
            Ingredient ingredient = (Ingredient)iterator.next();
            boolean found = false;
            for (int i2 = 0; i2 < 36; ++i2) {
                ItemStack stackInSlot;
                if (used[i2] || (stackInSlot = craftMatrix.func_70301_a(i2)).func_190926_b()) continue;
                if (this.isTool(stackInSlot.func_77973_b())) {
                    if (ingredient.func_193365_a().length <= 0) continue;
                    for (ItemStack matchStack : ingredient.func_193365_a()) {
                        if (stackInSlot.func_77973_b() != matchStack.func_77973_b()) continue;
                        used[i2] = true;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    iterator.remove();
                    break;
                }
                if (!ingredient.apply(stackInSlot)) continue;
                used[i2] = true;
                iterator.remove();
                found = true;
                break;
            }
            if (found) continue;
            boolean foundInSpecial = false;
            for (int i3 = 0; i3 < 2; ++i3) {
                ItemStack specialStack;
                if (!this.atelierRecipe.usesSpecialSlot(i3) || (specialStack = craftMatrix.func_70301_a(36 + i3)).func_190926_b() || !ingredient.apply(specialStack)) continue;
                iterator.remove();
                foundInSpecial = true;
                break;
            }
            if (foundInSpecial) continue;
            LOGGER.debug("Recipe {} does not match: missing ingredient", (Object)this.getRecipeOutput().func_82833_r());
            return false;
        }
        for (i = 0; i < 2; ++i) {
            ItemStack specialStack;
            if (!this.atelierRecipe.usesSpecialSlot(i) || !(specialStack = craftMatrix.func_70301_a(36 + i)).func_190926_b()) continue;
            LOGGER.debug("Recipe {} does not match: special slot {} is empty", (Object)this.getRecipeOutput().func_82833_r(), (Object)i);
            return false;
        }
        for (i = 0; i < 36; ++i) {
            if (craftMatrix.func_70301_a(i).func_190926_b() || used[i]) continue;
            return false;
        }
        boolean matches = ingredients.isEmpty();
        LOGGER.debug("Recipe match result for {}: {}", (Object)this.getRecipeOutput().func_82833_r(), (Object)matches);
        return matches;
    }

    private boolean isTool(Item item) {
        return item == ModTools.MARTEAU || item == ModTools.PINCE || item == ModTools.SCISSORS || item instanceof BlacksmithToolItem || item == Items.field_151131_as;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting craftMatrix) {
        return this.atelierRecipe.func_77571_b().func_77946_l();
    }

    @Override
    public int getRecipeSize() {
        return this.atelierRecipe.getRecipeSize();
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.atelierRecipe.func_77571_b();
    }

    @Override
    public int getLevelRequired() {
        return this.atelierRecipe.getLevelRequired();
    }

    @Override
    public int getXpReward() {
        return this.atelierRecipe.getBaseXpReward();
    }

    @Override
    public int getBaseXpReward() {
        return this.atelierRecipe.getBaseXpReward();
    }

    @Override
    public int getXpBonus(int stationType) {
        return stationType == 2 ? (int)((float)this.getBaseXpReward() * 0.5f) : 0;
    }

    @Override
    public boolean usesSpecialSlot(int slotIndex) {
        return this.atelierRecipe.usesSpecialSlot(slotIndex);
    }

    public IAtelierRecipe getOriginalRecipe() {
        return this.atelierRecipe;
    }
}

