/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.blacksmith.recipes;

import fr.minepiece.common.blocks.jobs.crafting.blacksmith.atelier.recipes.IAtelierRecipe;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.atelier.recipes.ShapedAtelierRecipe;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.forge.recipes.IForgeRecipe;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AtelierToForgeAdapter
implements IForgeRecipe {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Recipes");
    private final IAtelierRecipe atelierRecipe;
    private static final float XP_BONUS_MULTIPLIER = 0.5f;

    public AtelierToForgeAdapter(IAtelierRecipe atelierRecipe) {
        this.atelierRecipe = atelierRecipe;
        LOGGER.debug("Created adapter for recipe: {}", (Object)atelierRecipe.getRecipeOutput().func_82833_r());
    }

    @Override
    public boolean matches(InventoryCrafting craftMatrix, World world) {
        if (!(this.atelierRecipe instanceof ShapedAtelierRecipe)) {
            return false;
        }
        ShapedAtelierRecipe shapedRecipe = (ShapedAtelierRecipe)this.atelierRecipe;
        NonNullList inputs = shapedRecipe.func_192400_c();
        for (int y = 0; y < 6; ++y) {
            for (int x = 0; x < 6; ++x) {
                Ingredient target;
                int index = y * 6 + x;
                ItemStack stackInSlot = craftMatrix.func_70301_a(index);
                Ingredient ingredient = target = index < inputs.size() ? (Ingredient)inputs.get(index) : Ingredient.field_193370_a;
                if (target.apply(stackInSlot)) continue;
                return false;
            }
        }
        for (int i = 0; i < 2; ++i) {
            ItemStack specialItem;
            if (!this.atelierRecipe.usesSpecialSlot(i) || !(specialItem = craftMatrix.func_70301_a(36 + i)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting craftMatrix) {
        return this.atelierRecipe.getRecipeOutput().func_77946_l();
    }

    @Override
    public int getRecipeSize() {
        return this.atelierRecipe.getRecipeSize();
    }

    @Override
    public ItemStack getRecipeOutput() {
        return this.atelierRecipe.getRecipeOutput();
    }

    @Override
    public int getLevelRequired() {
        return this.atelierRecipe.getLevelRequired();
    }

    @Override
    public int getXpReward() {
        return this.atelierRecipe.getXpReward();
    }

    @Override
    public int getBaseXpReward() {
        return this.atelierRecipe.getXpReward();
    }

    @Override
    public int getXpBonus(int stationType) {
        return stationType == 2 ? (int)((float)this.getBaseXpReward() * 0.5f) : 0;
    }

    @Override
    public boolean usesSpecialSlot(int slotIndex) {
        return this.atelierRecipe.usesSpecialSlot(slotIndex);
    }

    public IAtelierRecipe getOriginalRecipe() {
        return this.atelierRecipe;
    }
}

