/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.blacksmith.forge.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.forge.recipes.IForgeRecipe;
import fr.minepiece.common.init.ModTools;
import fr.minepiece.common.items.jobs.blacksmith.BlacksmithToolItem;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapelessForgeRecipe
extends ShapelessOreRecipe
implements IForgeRecipe {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Recipes");
    private final int levelRequired;
    private final int xpReward;
    private final ResourceLocation recipeId;
    private final boolean[] specialSlotUsage;
    private final Ingredient[] specialSlotIngredients;

    public ShapelessForgeRecipe(ResourceLocation group, NonNullList<Ingredient> input, @Nonnull ItemStack result, int levelRequired, int xpReward, boolean[] specialSlotUsage, Ingredient[] specialSlotIngredients) {
        super(group, input, result);
        this.levelRequired = levelRequired;
        this.xpReward = xpReward;
        this.recipeId = group;
        this.specialSlotUsage = specialSlotUsage;
        this.specialSlotIngredients = specialSlotIngredients;
    }

    public boolean func_77569_a(InventoryCrafting craftMatrix, World world) {
        int i;
        ArrayList ingredients = new ArrayList(this.func_192400_c());
        if (ingredients.isEmpty()) {
            return false;
        }
        boolean[] used = new boolean[36];
        Iterator iterator = ingredients.iterator();
        while (iterator.hasNext()) {
            Ingredient ingredient = (Ingredient)iterator.next();
            boolean found = false;
            for (int i2 = 0; i2 < 36; ++i2) {
                ItemStack stackInSlot;
                if (used[i2] || (stackInSlot = craftMatrix.func_70301_a(i2)).func_190926_b()) continue;
                if (this.isTool(stackInSlot.func_77973_b())) {
                    if (ingredient.func_193365_a().length <= 0) continue;
                    for (ItemStack matchStack : ingredient.func_193365_a()) {
                        if (stackInSlot.func_77973_b() != matchStack.func_77973_b()) continue;
                        used[i2] = true;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    iterator.remove();
                    break;
                }
                if (!ingredient.apply(stackInSlot)) continue;
                used[i2] = true;
                iterator.remove();
                found = true;
                break;
            }
            if (found) continue;
            boolean foundInSpecial = false;
            for (int i3 = 0; i3 < 2; ++i3) {
                ItemStack specialStack;
                if (!this.specialSlotUsage[i3] || (specialStack = craftMatrix.func_70301_a(36 + i3)).func_190926_b()) continue;
                if (this.isTool(specialStack.func_77973_b())) {
                    for (ItemStack matchStack : ingredient.func_193365_a()) {
                        if (specialStack.func_77973_b() != matchStack.func_77973_b()) continue;
                        iterator.remove();
                        foundInSpecial = true;
                        break;
                    }
                    if (!foundInSpecial) continue;
                    break;
                }
                if (!ingredient.apply(specialStack)) continue;
                iterator.remove();
                foundInSpecial = true;
                break;
            }
            if (foundInSpecial) continue;
            return false;
        }
        for (i = 0; i < 36; ++i) {
            if (craftMatrix.func_70301_a(i).func_190926_b() || used[i]) continue;
            return false;
        }
        for (i = 0; i < 2; ++i) {
            if (!this.specialSlotUsage[i]) continue;
            ItemStack specialStack = craftMatrix.func_70301_a(36 + i);
            if (specialStack.func_190926_b()) {
                return false;
            }
            if (this.specialSlotIngredients[i].apply(specialStack)) continue;
            boolean isToolMatch = false;
            if (this.isTool(specialStack.func_77973_b())) {
                for (ItemStack matchStack : this.specialSlotIngredients[i].func_193365_a()) {
                    if (specialStack.func_77973_b() != matchStack.func_77973_b()) continue;
                    isToolMatch = true;
                    break;
                }
            }
            if (isToolMatch) continue;
            return false;
        }
        return ingredients.isEmpty();
    }

    private boolean isTool(Item item) {
        return item == ModTools.MARTEAU || item == ModTools.PINCE || item == ModTools.SCISSORS || item instanceof BlacksmithToolItem || item == Items.field_151131_as;
    }

    @Override
    public int getRecipeSize() {
        return this.func_192400_c().size() + (this.specialSlotUsage[0] ? 1 : 0) + (this.specialSlotUsage[1] ? 1 : 0);
    }

    @Override
    public int getLevelRequired() {
        return this.levelRequired;
    }

    @Override
    public int getXpReward() {
        return this.xpReward;
    }

    @Override
    public int getBaseXpReward() {
        return this.xpReward;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.func_77571_b().func_77946_l();
    }

    @Override
    public boolean usesSpecialSlot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.specialSlotUsage.length) {
            return false;
        }
        return this.specialSlotUsage[slotIndex];
    }

    public String toString() {
        return "ShapelessForgeRecipe{output=" + this.func_77571_b().func_82833_r() + ", recipeId=" + this.recipeId + ", levelRequired=" + this.levelRequired + ", xpReward=" + this.xpReward + '}';
    }

    public static class RecipeFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            try {
                NonNullList ingredients = NonNullList.func_191196_a();
                for (JsonElement element : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                    ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element, (JsonContext)context));
                }
                if (ingredients.isEmpty()) {
                    throw new JsonParseException("No ingredients for shapeless recipe");
                }
                boolean[] specialSlotUsage = new boolean[2];
                Ingredient[] specialSlotIngredients = new Ingredient[2];
                if (json.has("special_slots")) {
                    JsonObject specialSlots = JsonUtils.func_152754_s((JsonObject)json, (String)"special_slots");
                    if (specialSlots.has("slot1")) {
                        specialSlotUsage[0] = true;
                        specialSlotIngredients[0] = CraftingHelper.getIngredient((JsonElement)specialSlots.get("slot1"), (JsonContext)context);
                    }
                    if (specialSlots.has("slot2")) {
                        specialSlotUsage[1] = true;
                        specialSlotIngredients[1] = CraftingHelper.getIngredient((JsonElement)specialSlots.get("slot2"), (JsonContext)context);
                    }
                }
                ItemStack result = ShapedRecipes.func_192405_a((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
                int levelRequired = JsonUtils.func_151208_a((JsonObject)json, (String)"level_required", (int)1);
                int xpReward = JsonUtils.func_151208_a((JsonObject)json, (String)"xp_reward", (int)0);
                return new ShapelessForgeRecipe(group.isEmpty() ? null : new ResourceLocation(group), (NonNullList<Ingredient>)ingredients, result, levelRequired, xpReward, specialSlotUsage, specialSlotIngredients);
            }
            catch (Exception e) {
                LOGGER.error("Error parsing shapeless recipe: {}", (Object)e.getMessage());
                e.printStackTrace();
                throw e;
            }
        }
    }
}

