/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.blacksmith.forge.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.forge.recipes.IForgeRecipe;
import fr.minepiece.common.init.ModTools;
import fr.minepiece.common.items.jobs.blacksmith.BlacksmithToolItem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShapedForgeRecipe
extends ShapedOreRecipe
implements IForgeRecipe {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Recipes");
    private static final int GRID_WIDTH = 6;
    private static final int GRID_HEIGHT = 6;
    private final int levelRequired;
    private final int xpReward;
    private final int width;
    private final int height;
    private final NonNullList<Ingredient> input;
    private final boolean[] specialSlotUsage;
    private final Ingredient[] specialSlotIngredients;

    public ShapedForgeRecipe(ResourceLocation group, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer, int levelRequired, int xpReward, boolean[] specialSlotUsage, Ingredient[] specialSlotIngredients) {
        super(group, result, primer);
        this.levelRequired = levelRequired;
        this.xpReward = xpReward;
        this.width = primer.width;
        this.height = primer.height;
        this.input = primer.input;
        this.specialSlotUsage = specialSlotUsage;
        this.specialSlotIngredients = specialSlotIngredients;
    }

    public boolean func_77569_a(InventoryCrafting craftMatrix, World world) {
        for (int startX = 0; startX <= 6 - this.width; ++startX) {
            for (int startY = 0; startY <= 6 - this.height; ++startY) {
                if (this.checkMatch(craftMatrix, startX, startY, false) && this.checkSpecialSlots(craftMatrix)) {
                    return true;
                }
                if (!this.checkMatch(craftMatrix, startX, startY, true) || !this.checkSpecialSlots(craftMatrix)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkSpecialSlots(InventoryCrafting craftMatrix) {
        for (int i = 0; i < 2; ++i) {
            if (!this.specialSlotUsage[i]) continue;
            ItemStack specialItem = craftMatrix.func_70301_a(36 + i);
            if (specialItem.func_190926_b()) {
                return false;
            }
            if (this.isTool(specialItem.func_77973_b())) {
                boolean toolMatches = false;
                for (ItemStack matchStack : this.specialSlotIngredients[i].func_193365_a()) {
                    if (specialItem.func_77973_b() != matchStack.func_77973_b()) continue;
                    toolMatches = true;
                    break;
                }
                if (toolMatches) continue;
                return false;
            }
            if (this.specialSlotIngredients[i].apply(specialItem)) continue;
            return false;
        }
        return true;
    }

    public boolean checkMatch(InventoryCrafting craftMatrix, int startX, int startY, boolean mirrored) {
        int x;
        int y;
        for (y = 0; y < this.height; ++y) {
            for (x = 0; x < this.width; ++x) {
                int inputIndex = y * this.width + x;
                int craftY = startY + y;
                int craftX = startX + x;
                int craftIndex = craftY * 6 + craftX;
                if (craftIndex >= 36) {
                    return false;
                }
                Ingredient ingredient = mirrored ? (Ingredient)this.input.get(this.width - x - 1 + y * this.width) : (Ingredient)this.input.get(inputIndex);
                ItemStack craftItem = craftMatrix.func_70301_a(craftIndex);
                if (ingredient == Ingredient.field_193370_a) {
                    if (craftItem.func_190926_b()) continue;
                    return false;
                }
                if (!craftItem.func_190926_b() && this.isTool(craftItem.func_77973_b())) {
                    boolean toolMatches = false;
                    for (ItemStack matchStack : ingredient.func_193365_a()) {
                        if (craftItem.func_77973_b() != matchStack.func_77973_b()) continue;
                        toolMatches = true;
                        break;
                    }
                    if (toolMatches) continue;
                    return false;
                }
                if (ingredient.apply(craftItem)) continue;
                return false;
            }
        }
        for (y = 0; y < 6; ++y) {
            for (x = 0; x < 6; ++x) {
                int index;
                if (x >= startX && x < startX + this.width && y >= startY && y < startY + this.height || (index = y * 6 + x) >= 36 || craftMatrix.func_70301_a(index).func_190926_b()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isTool(Item item) {
        return item == ModTools.MARTEAU || item == ModTools.PINCE || item == ModTools.SCISSORS || item instanceof BlacksmithToolItem;
    }

    @Override
    public int getLevelRequired() {
        return this.levelRequired;
    }

    @Override
    public int getXpReward() {
        return this.xpReward;
    }

    @Override
    public boolean usesSpecialSlot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.specialSlotUsage.length) {
            return false;
        }
        return this.specialSlotUsage[slotIndex];
    }

    public ItemStack func_77572_b(InventoryCrafting craftMatrix) {
        return this.func_77571_b().func_77946_l();
    }

    @Override
    public int getRecipeSize() {
        return this.width * this.height;
    }

    public ItemStack func_77571_b() {
        return super.func_77571_b();
    }

    public static class RecipeFactory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            try {
                HashMap<Character, Ingredient> ingredientMap = new HashMap<Character, Ingredient>();
                for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
                    if (((String)entry.getKey()).length() != 1) {
                        throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                    }
                    if (" ".equals(entry.getKey())) {
                        throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                    }
                    ingredientMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
                }
                ingredientMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
                JsonArray pattern = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
                if (pattern.size() == 0) {
                    throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
                }
                String[] rows = new String[pattern.size()];
                for (int i = 0; i < rows.length; ++i) {
                    rows[i] = JsonUtils.func_151206_a((JsonElement)pattern.get(i), (String)("pattern[" + i + "]"));
                }
                int width = rows[0].length();
                int height = rows.length;
                if (height > 6) {
                    throw new JsonSyntaxException("Invalid pattern: too many rows, 6 is maximum");
                }
                if (width > 6) {
                    throw new JsonSyntaxException("Invalid pattern: too many columns, 6 is maximum");
                }
                CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
                primer.width = width;
                primer.height = height;
                primer.mirrored = false;
                primer.input = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
                HashSet keys = new HashSet(ingredientMap.keySet());
                keys.remove(Character.valueOf(' '));
                for (int y = 0; y < height; ++y) {
                    String row = rows[y];
                    for (int x = 0; x < row.length(); ++x) {
                        char c = row.charAt(x);
                        Ingredient ingredient = (Ingredient)ingredientMap.get(Character.valueOf(c));
                        if (ingredient == null) {
                            throw new JsonSyntaxException("Pattern references symbol '" + c + "' but it's not defined in the key");
                        }
                        primer.input.set(x + y * width, (Object)ingredient);
                        keys.remove(Character.valueOf(c));
                    }
                }
                if (!keys.isEmpty()) {
                    throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
                }
                boolean[] specialSlotUsage = new boolean[2];
                Ingredient[] specialSlotIngredients = new Ingredient[2];
                if (json.has("special_slots")) {
                    JsonObject specialSlots = JsonUtils.func_152754_s((JsonObject)json, (String)"special_slots");
                    if (specialSlots.has("slot1")) {
                        specialSlotUsage[0] = true;
                        specialSlotIngredients[0] = CraftingHelper.getIngredient((JsonElement)specialSlots.get("slot1"), (JsonContext)context);
                    }
                    if (specialSlots.has("slot2")) {
                        specialSlotUsage[1] = true;
                        specialSlotIngredients[1] = CraftingHelper.getIngredient((JsonElement)specialSlots.get("slot2"), (JsonContext)context);
                    }
                }
                ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
                int levelRequired = JsonUtils.func_151208_a((JsonObject)json, (String)"level_required", (int)1);
                int xpReward = JsonUtils.func_151208_a((JsonObject)json, (String)"xp_reward", (int)0);
                return new ShapedForgeRecipe(group.isEmpty() ? null : new ResourceLocation(group), result, primer, levelRequired, xpReward, specialSlotUsage, specialSlotIngredients);
            }
            catch (Exception e) {
                LOGGER.error("Error parsing recipe: {}", (Object)e.getMessage());
                throw e;
            }
        }
    }
}

