/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.blacksmith.forge.recipes;

import fr.minepiece.common.blocks.jobs.crafting.blacksmith.atelier.recipes.IAtelierRecipe;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.atelier.recipes.ShapedAtelierRecipe;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.atelier.recipes.ShapelessAtelierRecipe;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.forge.recipes.IForgeRecipe;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.recipes.AtelierToForgeAdapter;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.recipes.ShapelessAtelierToForgeAdapter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeRecipeManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Recipes");
    private static List<AtelierToForgeAdapter> shapedAdaptedRecipes = null;
    private static List<ShapelessAtelierToForgeAdapter> shapelessAdaptedRecipes = null;

    public static void initializeAdapters() {
        if (shapedAdaptedRecipes == null) {
            LOGGER.info("Initializing adapted recipes for Forge");
            shapedAdaptedRecipes = new ArrayList<AtelierToForgeAdapter>();
            shapelessAdaptedRecipes = new ArrayList<ShapelessAtelierToForgeAdapter>();
            for (IRecipe irecipe : CraftingManager.field_193380_a) {
                IForgeRecipe adapter;
                IAtelierRecipe recipe;
                if (irecipe instanceof ShapedAtelierRecipe) {
                    recipe = (ShapedAtelierRecipe)irecipe;
                    adapter = new AtelierToForgeAdapter(recipe);
                    shapedAdaptedRecipes.add((AtelierToForgeAdapter)adapter);
                    LOGGER.debug("Added adapter for shaped recipe: {}", (Object)((ShapedAtelierRecipe)recipe).func_77571_b().func_82833_r());
                    continue;
                }
                if (!(irecipe instanceof ShapelessAtelierRecipe)) continue;
                recipe = (ShapelessAtelierRecipe)irecipe;
                adapter = new ShapelessAtelierToForgeAdapter((ShapelessAtelierRecipe)recipe);
                shapelessAdaptedRecipes.add((ShapelessAtelierToForgeAdapter)adapter);
                LOGGER.debug("Added adapter for shapeless recipe: {}", (Object)recipe.func_77571_b().func_82833_r());
            }
            LOGGER.info("Created {} shaped recipe adapters and {} shapeless recipe adapters", (Object)shapedAdaptedRecipes.size(), (Object)shapelessAdaptedRecipes.size());
        }
    }

    public static List<AtelierToForgeAdapter> getShapedAdaptedRecipes() {
        if (shapedAdaptedRecipes == null) {
            ForgeRecipeManager.initializeAdapters();
        }
        return shapedAdaptedRecipes;
    }

    public static List<ShapelessAtelierToForgeAdapter> getShapelessAdaptedRecipes() {
        if (shapelessAdaptedRecipes == null) {
            ForgeRecipeManager.initializeAdapters();
        }
        return shapelessAdaptedRecipes;
    }

    public static boolean isAdaptedRecipe(IRecipe recipe) {
        return recipe instanceof AtelierToForgeAdapter || recipe instanceof ShapelessAtelierToForgeAdapter;
    }

    public static IAtelierRecipe getOriginalRecipe(IRecipe recipe) {
        if (recipe instanceof AtelierToForgeAdapter) {
            return ((AtelierToForgeAdapter)recipe).getOriginalRecipe();
        }
        if (recipe instanceof ShapelessAtelierToForgeAdapter) {
            return ((ShapelessAtelierToForgeAdapter)recipe).getOriginalRecipe();
        }
        return null;
    }
}

