/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.blacksmith.forge.container;

import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.forge.recipes.ForgeRecipeManager;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.forge.recipes.IForgeRecipe;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.forge.slots.SlotForgeOutput;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.recipes.AtelierToForgeAdapter;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.recipes.ShapelessAtelierToForgeAdapter;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.init.ModTools;
import fr.minepiece.common.items.jobs.blacksmith.BlacksmithToolItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContainerForge
extends Container {
    private static final Logger LOGGER = LogManager.getLogger((String)"MinePiece Craft");
    private static final int STATION_TYPE = 2;
    public InventoryCrafting craftMatrix;
    public InventoryCraftResult craftResult;
    private final World world;
    private final BlockPos pos;
    private final EntityPlayer player;
    private boolean hasProcessedRecipe = false;

    public ContainerForge(InventoryPlayer playerInventory, World worldIn, BlockPos posIn) {
        int col;
        int row;
        this.world = worldIn;
        this.pos = posIn;
        this.player = playerInventory.field_70458_d;
        this.craftMatrix = new InventoryCrafting((Container)this, 6, 7);
        this.craftResult = new InventoryCraftResult();
        this.func_75146_a((Slot)new SlotForgeOutput(playerInventory.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, 143, 76));
        for (row = 0; row < 6; ++row) {
            for (col = 0; col < 6; ++col) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, col + row * 6, 13 + col * 18, 32 + row * 18));
            }
        }
        this.func_75146_a(new Slot((IInventory)this.craftMatrix, 36, 13, 10));
        this.func_75146_a(new Slot((IInventory)this.craftMatrix, 37, 125, 122));
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)playerInventory, col + row * 9 + 9, 8 + col * 18, 166 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.func_75146_a(new Slot((IInventory)playerInventory, col2, 8 + col2 * 18, 224));
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        this.hasProcessedRecipe = false;
        IRecipe matchingRecipe = null;
        ItemStack resultStack = ItemStack.field_190927_a;
        ForgeRecipeManager.initializeAdapters();
        for (IRecipe iRecipe : CraftingManager.field_193380_a) {
            if (!(iRecipe instanceof IForgeRecipe)) continue;
            IForgeRecipe forgeRecipe = (IForgeRecipe)iRecipe;
            IMinePieceData mpData = (IMinePieceData)this.player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
            if (mpData == null || mpData.getJob() != MinePieceJobs.BLACKSMITH || mpData.getJobLevel() < forgeRecipe.getLevelRequired() || mpData.getDailyCraftLimit() <= 0 || !forgeRecipe.matches(this.craftMatrix, this.world)) continue;
            matchingRecipe = iRecipe;
            resultStack = iRecipe.func_77572_b(this.craftMatrix);
            break;
        }
        if (matchingRecipe == null) {
            IMinePieceData mpData;
            for (AtelierToForgeAdapter atelierToForgeAdapter : ForgeRecipeManager.getShapedAdaptedRecipes()) {
                mpData = (IMinePieceData)this.player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
                if (mpData == null || mpData.getJob() != MinePieceJobs.BLACKSMITH || mpData.getJobLevel() < atelierToForgeAdapter.getLevelRequired() || mpData.getDailyCraftLimit() <= 0 || !atelierToForgeAdapter.matches(this.craftMatrix, this.world)) continue;
                matchingRecipe = (IRecipe)atelierToForgeAdapter;
                resultStack = atelierToForgeAdapter.getCraftingResult(this.craftMatrix);
                break;
            }
            if (matchingRecipe == null) {
                for (ShapelessAtelierToForgeAdapter shapelessAtelierToForgeAdapter : ForgeRecipeManager.getShapelessAdaptedRecipes()) {
                    mpData = (IMinePieceData)this.player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
                    if (mpData == null || mpData.getJob() != MinePieceJobs.BLACKSMITH || mpData.getJobLevel() < shapelessAtelierToForgeAdapter.getLevelRequired() || mpData.getDailyCraftLimit() <= 0 || !shapelessAtelierToForgeAdapter.matches(this.craftMatrix, this.world)) continue;
                    matchingRecipe = (IRecipe)shapelessAtelierToForgeAdapter;
                    resultStack = shapelessAtelierToForgeAdapter.getCraftingResult(this.craftMatrix);
                    break;
                }
            }
        }
        this.craftResult.func_70299_a(0, resultStack);
        if (matchingRecipe != null) {
            this.craftResult.func_193056_a(matchingRecipe);
        } else {
            this.craftResult.func_193056_a(null);
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer playerIn) {
        IRecipe recipe;
        HashMap<Integer, ItemStack> toolsBefore = new HashMap<Integer, ItemStack>();
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack stack = this.craftMatrix.func_70301_a(i);
            if (stack.func_190926_b() || !this.isSpecialTool(stack.func_77973_b())) continue;
            toolsBefore.put(i, stack.func_77946_l());
        }
        if (slotId == 0 && !this.hasProcessedRecipe && !this.craftResult.func_70301_a(0).func_190926_b() && (recipe = this.craftResult.func_193055_i()) instanceof IForgeRecipe) {
            this.hasProcessedRecipe = true;
            this.handleCraftCompletion((IForgeRecipe)recipe);
        }
        ItemStack result = super.func_184996_a(slotId, dragType, clickTypeIn, playerIn);
        if (slotId == 0 && !result.func_190926_b()) {
            this.restoreToolsWithDamage(toolsBefore);
        }
        return result;
    }

    private void restoreToolsWithDamage(Map<Integer, ItemStack> toolsBefore) {
        if (toolsBefore.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, ItemStack> entry : toolsBefore.entrySet()) {
            int slotIndex = entry.getKey();
            ItemStack toolStack = entry.getValue().func_77946_l();
            if (!this.craftMatrix.func_70301_a(slotIndex).func_190926_b()) continue;
            if (toolStack.func_77973_b().func_77645_m()) {
                boolean broke = false;
                if (this.player instanceof EntityPlayerMP) {
                    broke = toolStack.func_96631_a(1, this.player.func_70681_au(), (EntityPlayerMP)this.player);
                } else {
                    toolStack.func_77964_b(toolStack.func_77952_i() + 1);
                    boolean bl = broke = toolStack.func_77952_i() >= toolStack.func_77958_k();
                }
                if (broke) continue;
                this.craftMatrix.func_70299_a(slotIndex, toolStack);
                continue;
            }
            this.craftMatrix.func_70299_a(slotIndex, toolStack);
        }
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 0) {
                IRecipe recipe = this.craftResult.func_193055_i();
                HashMap<Integer, ItemStack> toolSlots = new HashMap<Integer, ItemStack>();
                for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                    ItemStack stack = this.craftMatrix.func_70301_a(i);
                    if (stack.func_190926_b() || !this.isSpecialTool(stack.func_77973_b())) continue;
                    toolSlots.put(i, stack.func_77946_l());
                    this.craftMatrix.func_70299_a(i, ItemStack.field_190927_a);
                }
                if (recipe instanceof IForgeRecipe && !this.hasProcessedRecipe) {
                    this.hasProcessedRecipe = true;
                    this.handleCraftCompletion((IForgeRecipe)recipe);
                }
                if (!this.func_75135_a(itemstack1, 39, 75, true)) {
                    for (Map.Entry entry : toolSlots.entrySet()) {
                        this.craftMatrix.func_70299_a(((Integer)entry.getKey()).intValue(), (ItemStack)entry.getValue());
                    }
                    return ItemStack.field_190927_a;
                }
                for (Map.Entry entry : toolSlots.entrySet()) {
                    ItemStack toolStack = (ItemStack)entry.getValue();
                    boolean broke = false;
                    if (toolStack.func_77973_b().func_77645_m() && this.player instanceof EntityPlayerMP) {
                        broke = toolStack.func_96631_a(1, this.player.func_70681_au(), (EntityPlayerMP)this.player);
                    }
                    if (broke) continue;
                    this.craftMatrix.func_70299_a(((Integer)entry.getKey()).intValue(), toolStack);
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= 1 && index < 39 ? !this.func_75135_a(itemstack1, 39, 75, false) : index >= 39 && index < 75 && !this.func_75135_a(itemstack1, 1, 39, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    private void handleCraftCompletion(IForgeRecipe recipe) {
        if (!(this.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP playerMP = (EntityPlayerMP)this.player;
        IMinePieceData mpData = (IMinePieceData)this.player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (mpData == null) {
            return;
        }
        int baseXp = recipe.getBaseXpReward();
        int xpBonus = recipe.getXpBonus(2);
        int totalXp = baseXp + xpBonus;
        PlayerUtils.addJobXpToPlayer(playerMP, totalXp);
        int newLimit = mpData.getDailyCraftLimit() - 1;
        mpData.setDailyCraftLimit(Math.max(0, newLimit));
        mpData.clientSync(playerMP);
        StringBuilder message = new StringBuilder();
        message.append(TextFormatting.GREEN).append("Craft r\u00e9ussi ! ");
        message.append(TextFormatting.GOLD).append("+").append(totalXp).append(" XP");
        if (xpBonus > 0) {
            message.append(TextFormatting.GREEN).append(" (").append(TextFormatting.GOLD).append("+").append(xpBonus).append(" ").append(TextFormatting.GREEN).append("bonus)");
        }
        this.player.func_145747_a((ITextComponent)new TextComponentString(message.toString()));
        this.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Craft journalier restant : " + TextFormatting.GOLD + mpData.getDailyCraftLimit()));
    }

    private boolean isSpecialTool(Item item) {
        return item == ModTools.MARTEAU || item == ModTools.PINCE || item == ModTools.SCISSORS || item instanceof BlacksmithToolItem || item == Items.field_151131_as;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!this.world.field_72995_K) {
            for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                ItemStack stack = this.craftMatrix.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                playerIn.field_71071_by.func_191975_a(this.world, stack);
            }
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        IMinePieceData mpData = (IMinePieceData)playerIn.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        return mpData != null && mpData.getJob() == MinePieceJobs.BLACKSMITH && mpData.getDailyCraftLimit() > 0 && playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }
}

