/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.blacksmith.fonderie.tileentity;

import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.fonderie.BlockFonderie;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.fonderie.recipes.FonderieRecipes;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.init.ModItems;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFonderie
extends TileEntity
implements IInventory,
ITickable {
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private String customName;
    private int burnTime;
    private int currentBurnTime;
    private int cookTime;
    private int totalCookTime;

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "container.fonderie";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (!(index != 0 && index != 1 && index != 2 || flag)) {
            this.totalCookTime = this.getCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.burnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("TotalCookTime");
        this.currentBurnTime = TileEntityFonderie.getItemBurnTime((ItemStack)this.inventory.get(1));
        if (compound.func_150297_b("CustomName", 8)) {
            this.setCustomName(compound.func_74779_i("CustomName"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("TotalCookTime", this.totalCookTime);
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack input = (ItemStack)this.inventory.get(0);
            ItemStack charbon = (ItemStack)this.inventory.get(1);
            ItemStack moule = (ItemStack)this.inventory.get(2);
            EntityPlayer player = this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0, false);
            boolean mouleRequis = true;
            if (player != null && !input.func_190926_b()) {
                mouleRequis = FonderieRecipes.getInstance().requiresMould(input);
            }
            if (!(input.func_190926_b() || charbon.func_190926_b() || mouleRequis && moule.func_190926_b() || this.isBurning())) {
                ItemStack result = ItemStack.field_190927_a;
                if (player != null) {
                    IMinePieceData mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
                    if (mpData != null) {
                        result = FonderieRecipes.getInstance().getFonderieResult(input, player);
                        if (result.func_190926_b()) {
                            MinePieceJobs currentJob = mpData.getJob();
                            if (currentJob != MinePieceJobs.BLACKSMITH && currentJob != MinePieceJobs.MEDIC) {
                                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7cVous devez \u00eatre forgeron ou m\u00e9decin pour utiliser cette recette"));
                            } else {
                                int requiredLevel = FonderieRecipes.getInstance().getLevelRequirement(input);
                                if (mpData.getJobLevel() < requiredLevel) {
                                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7cNiveau " + requiredLevel + " requis pour cette recette"));
                                } else {
                                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7cRecette non disponible pour votre m\u00e9tier"));
                                }
                            }
                        }
                    } else {
                        result = FonderieRecipes.getInstance().getFonderieResult(input);
                    }
                } else {
                    result = FonderieRecipes.getInstance().getFonderieResult(input);
                }
                if (!result.func_190926_b()) {
                    this.currentBurnTime = this.burnTime = TileEntityFonderie.getItemBurnTime(charbon);
                    if (this.burnTime > 0) {
                        flag1 = true;
                        charbon.func_190918_g(1);
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.cookTime;
                if (this.cookTime == this.totalCookTime) {
                    this.cookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            } else {
                this.cookTime = 0;
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                BlockFonderie.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public int getCookTime() {
        return 600;
    }

    private boolean canSmelt() {
        ItemStack input = (ItemStack)this.inventory.get(0);
        ItemStack moule = (ItemStack)this.inventory.get(2);
        if (input.func_190926_b()) {
            return false;
        }
        EntityPlayer player = this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0, false);
        boolean mouleRequis = true;
        if (player != null) {
            mouleRequis = FonderieRecipes.getInstance().requiresMould(input);
        }
        if (mouleRequis && (moule.func_190926_b() || !TileEntityFonderie.isMoule(moule))) {
            return false;
        }
        ItemStack result = player != null ? FonderieRecipes.getInstance().getFonderieResult(input, player) : FonderieRecipes.getInstance().getFonderieResult(input);
        if (result.func_190926_b()) {
            return false;
        }
        ItemStack output = (ItemStack)this.inventory.get(3);
        if (output.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(result)) {
            return false;
        }
        int res = output.func_190916_E() + result.func_190916_E();
        return res <= this.func_70297_j_() && res <= output.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            IMinePieceData mpData;
            ItemStack result;
            ItemStack input = (ItemStack)this.inventory.get(0);
            ItemStack moule = (ItemStack)this.inventory.get(2);
            EntityPlayer player = this.field_145850_b.func_184137_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0, false);
            boolean mouleRequis = true;
            if (player != null) {
                mouleRequis = FonderieRecipes.getInstance().requiresMould(input);
            }
            if ((result = player != null ? FonderieRecipes.getInstance().getFonderieResult(input, player) : FonderieRecipes.getInstance().getFonderieResult(input)).func_190926_b()) {
                return;
            }
            ItemStack output = (ItemStack)this.inventory.get(3);
            if (output.func_190926_b()) {
                this.inventory.set(3, (Object)result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }
            if (player != null && player instanceof EntityPlayerMP && (mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) != null) {
                float experience = FonderieRecipes.getInstance().getFonderieExperience(result);
                PlayerUtils.addJobXpToPlayer((EntityPlayerMP)player, (int)experience);
                mpData.clientSync((EntityPlayerMP)player);
                if (mpData.getDailyCraftLimit() > 0) {
                    mpData.setDailyCraftLimit(mpData.getDailyCraftLimit() - 1);
                    mpData.clientSync((EntityPlayerMP)player);
                }
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7aFusion r\u00e9ussie ! \u00a76+" + (int)experience + " XP"));
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7aCraft journalier restant : \u00a76" + mpData.getDailyCraftLimit()));
            }
            input.func_190918_g(1);
            if (mouleRequis && !moule.func_190926_b()) {
                if (player != null && player.hasCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) {
                    mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
                    if (mpData != null) {
                        int jobLevel = mpData.getJobLevel();
                        int durabilityChance = Math.min(80, jobLevel * 5);
                        if (this.field_145850_b.field_73012_v.nextInt(100) >= durabilityChance) {
                            moule.func_190918_g(1);
                        }
                    } else {
                        moule.func_190918_g(1);
                    }
                } else {
                    moule.func_190918_g(1);
                }
            }
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Blocks.field_150402_ci.func_180660_a(Blocks.field_150402_ci.func_176223_P(), new Random(), 0)) {
            return 16000;
        }
        return 0;
    }

    public static boolean isMoule(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return stack.func_77973_b() == ModItems.MOULE_LINGOT;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 3) {
            return false;
        }
        if (index == 1) {
            return TileEntityFonderie.getItemBurnTime(stack) > 0;
        }
        if (index == 2) {
            return TileEntityFonderie.isMoule(stack);
        }
        return true;
    }

    public String getGuiID() {
        return "minepiece:fonderie";
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.burnTime;
            }
            case 1: {
                return this.currentBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.burnTime = value;
                break;
            }
            case 1: {
                this.currentBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }
}

