/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.blacksmith.fonderie.recipes;

import com.google.common.collect.Maps;
import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.init.ModItems;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class FonderieRecipes {
    private static final FonderieRecipes INSTANCE = new FonderieRecipes();
    private final Map<ItemStack, ItemStack> smeltingList = Maps.newHashMap();
    private final Map<ItemStack, Float> experienceList = Maps.newHashMap();
    private final Map<ItemStack, Integer> levelRequirements = Maps.newHashMap();
    private final Map<ItemStack, Set<MinePieceJobs>> allowedJobs = Maps.newHashMap();
    private final Map<ItemStack, Boolean> requiresMouldMap = Maps.newHashMap();

    public static FonderieRecipes getInstance() {
        return INSTANCE;
    }

    private FonderieRecipes() {
        this.addFonderieRecipe(new ItemStack(ModItems.FER_BRUT), new ItemStack(ModItems.FER_RAFFINE), 2, 11.0f, new MinePieceJobs[]{MinePieceJobs.BLACKSMITH}, true);
        this.addFonderieRecipe(new ItemStack(ModItems.OR_BRUT), new ItemStack(ModItems.OR_RAFFINE), 2, 12.0f, new MinePieceJobs[]{MinePieceJobs.BLACKSMITH}, true);
        this.addFonderieRecipe(new ItemStack(ModItems.DIAMANT_BRUT), new ItemStack(ModItems.DIAMANT_RAFFINE), 2, 11.0f, new MinePieceJobs[]{MinePieceJobs.BLACKSMITH}, true);
        this.addFonderieRecipe(new ItemStack(ModItems.OBSIDIENNE_BRUT), new ItemStack(ModItems.OBSIDIENNE_POLIE), 2, 11.0f, new MinePieceJobs[]{MinePieceJobs.BLACKSMITH}, true);
        this.addFonderieRecipe(new ItemStack((Block)Blocks.field_150354_m), new ItemStack(ModItems.VERRE, 4), 4, 13.0f, new MinePieceJobs[]{MinePieceJobs.MEDIC}, false);
    }

    public void addFonderieRecipe(ItemStack input, ItemStack result, int levelRequired, float experience, MinePieceJobs[] jobs, boolean requiresMould) {
        if (this.getFonderieResult(input) != ItemStack.field_190927_a) {
            return;
        }
        this.smeltingList.put(input, result);
        this.experienceList.put(result, Float.valueOf(experience));
        this.levelRequirements.put(input, levelRequired);
        this.requiresMouldMap.put(input, requiresMould);
        HashSet<MinePieceJobs> jobSet = new HashSet<MinePieceJobs>(Arrays.asList(jobs));
        this.allowedJobs.put(input, jobSet);
    }

    public void addFonderieRecipe(ItemStack input, ItemStack result, float experience) {
        this.addFonderieRecipe(input, result, 1, experience, new MinePieceJobs[]{MinePieceJobs.BLACKSMITH}, true);
    }

    public void addFonderieRecipe(ItemStack input, ItemStack result, int levelRequired, float experience) {
        this.addFonderieRecipe(input, result, levelRequired, experience, new MinePieceJobs[]{MinePieceJobs.BLACKSMITH}, true);
    }

    public void addFonderieRecipe(ItemStack input, ItemStack result, int levelRequired, float experience, MinePieceJobs[] jobs) {
        this.addFonderieRecipe(input, result, levelRequired, experience, jobs, true);
    }

    public ItemStack getFonderieResult(ItemStack input) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.smeltingList.entrySet()) {
            if (!this.compareItemStacks(input, entry.getKey())) continue;
            return entry.getValue().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getFonderieResult(ItemStack input, EntityPlayer player) {
        for (Map.Entry<ItemStack, ItemStack> entry : this.smeltingList.entrySet()) {
            IMinePieceData mpData;
            if (!this.compareItemStacks(input, entry.getKey())) continue;
            if (player != null && player.hasCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null) && (mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)) != null) {
                int requiredLevel = this.getLevelRequirement(input);
                Set<MinePieceJobs> validJobs = this.getAllowedJobs(input);
                if (!validJobs.contains((Object)mpData.getJob())) {
                    return ItemStack.field_190927_a;
                }
                if (mpData.getJobLevel() < requiredLevel) {
                    return ItemStack.field_190927_a;
                }
                return entry.getValue().func_77946_l();
            }
            return entry.getValue().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public int getLevelRequirement(ItemStack input) {
        for (Map.Entry<ItemStack, Integer> entry : this.levelRequirements.entrySet()) {
            if (!this.compareItemStacks(input, entry.getKey())) continue;
            return entry.getValue();
        }
        return 1;
    }

    public Set<MinePieceJobs> getAllowedJobs(ItemStack input) {
        for (Map.Entry<ItemStack, Set<MinePieceJobs>> entry : this.allowedJobs.entrySet()) {
            if (!this.compareItemStacks(input, entry.getKey())) continue;
            return entry.getValue();
        }
        HashSet<MinePieceJobs> defaultJobs = new HashSet<MinePieceJobs>();
        defaultJobs.add(MinePieceJobs.BLACKSMITH);
        return defaultJobs;
    }

    public boolean requiresMould(ItemStack input) {
        for (Map.Entry<ItemStack, Boolean> entry : this.requiresMouldMap.entrySet()) {
            if (!this.compareItemStacks(input, entry.getKey())) continue;
            return entry.getValue();
        }
        return true;
    }

    private boolean compareItemStacks(ItemStack stack1, ItemStack stack2) {
        return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
    }

    public Map<ItemStack, ItemStack> getSmeltingList() {
        return this.smeltingList;
    }

    public float getFonderieExperience(ItemStack stack) {
        for (Map.Entry<ItemStack, Float> entry : this.experienceList.entrySet()) {
            if (!this.compareItemStacks(stack, entry.getKey())) continue;
            return entry.getValue().floatValue();
        }
        return 0.0f;
    }
}

