/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.jobs.crafting.blacksmith.fonderie;

import fr.minepiece.MinePiece;
import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.blocks.BlockRotatable;
import fr.minepiece.common.blocks.jobs.crafting.blacksmith.fonderie.tileentity.TileEntityFonderie;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.init.ModBlocks;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class BlockFonderie
extends BlockRotatable
implements ITileEntityProvider {
    public static final PropertyBool MELTING = PropertyBool.func_177716_a((String)"melting");
    private final int requiredLevel;

    public BlockFonderie(Material material, String name, int requiredLevel) {
        super(material, name);
        this.func_149672_a(SoundType.field_185852_e);
        this.requiredLevel = requiredLevel;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)MELTING, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(MinePiece.JOBS);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.FONDERIE);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Block)ModBlocks.FONDERIE);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            Capability<IMinePieceData> capability = MinePieceDataStorage.MP_DATA_CAPABILITY;
            IMinePieceData mpData = (IMinePieceData)playerIn.getCapability(capability, null);
            if (mpData == null) {
                return false;
            }
            if (mpData.getJob() != MinePieceJobs.BLACKSMITH && mpData.getJob() != MinePieceJobs.MEDIC) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.fonderie.wrong_job", new Object[0]));
                return false;
            }
            if (mpData.getJobLevel() < this.requiredLevel) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.fonderie.level_too_low", new Object[]{this.requiredLevel}));
                return false;
            }
            if (mpData.getDailyCraftLimit() <= 0) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("message.fonderie.daily_limit", new Object[0]));
                return false;
            }
            playerIn.openGui((Object)MinePiece.INSTANCE, 310, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (active) {
            worldIn.func_180501_a(pos, ModBlocks.FONDERIE.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)MELTING, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            worldIn.func_180501_a(pos, ModBlocks.FONDERIE.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)MELTING, (Comparable)Boolean.valueOf(false)), 3);
        }
        if (tileentity != null) {
            tileentity.func_145829_t();
            worldIn.func_175690_a(pos, tileentity);
        }
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFonderie();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityFonderie tileentity = (TileEntityFonderie)worldIn.func_175625_s(pos);
        InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)tileentity);
        super.func_180663_b(worldIn, pos, state);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MELTING, FACING});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta & 7));
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)MELTING, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)MELTING)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

