/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.furniture;

import com.google.common.collect.Lists;
import fr.minepiece.common.api.utils.CollisionUtils;
import fr.minepiece.common.api.utils.SeatUtils;
import fr.minepiece.common.blocks.BlockRotatable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockhospitalSofaThirdWhite
extends BlockRotatable {
    public static AxisAlignedBB BOUNDING_BOX;
    public static AxisAlignedBB BOUNDING_BOX_NORTH;
    public static AxisAlignedBB BOUNDING_BOX_EAST;
    public static AxisAlignedBB BOUNDING_BOX_SOUTH;
    public static AxisAlignedBB BOUNDING_BOX_WEST;
    public static AxisAlignedBB SEAT_NORTH;
    public static AxisAlignedBB SEAT_EAST;
    public static AxisAlignedBB SEAT_WEST;
    public static AxisAlignedBB SEAT_SOUTH;
    public static AxisAlignedBB REST_NORTH;
    public static AxisAlignedBB REST_EAST;
    public static AxisAlignedBB REST_WEST;
    public static AxisAlignedBB REST_SOUTH;
    public static AxisAlignedBB REST_RIGHT_NORTH;
    public static AxisAlignedBB REST_RIGHT_EAST;
    public static AxisAlignedBB REST_RIGHT_WEST;
    public static AxisAlignedBB REST_RIGHT_SOUTH;
    public static AxisAlignedBB REST_LEFT_NORTH;
    public static AxisAlignedBB REST_LEFT_EAST;
    public static AxisAlignedBB REST_LEFT_WEST;
    public static AxisAlignedBB REST_LEFT_SOUTH;

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case EAST: {
                list.add(SEAT_EAST);
                list.add(REST_EAST);
                list.add(REST_RIGHT_EAST);
                list.add(REST_LEFT_EAST);
                BOUNDING_BOX = BOUNDING_BOX_EAST;
                break;
            }
            case SOUTH: {
                list.add(SEAT_SOUTH);
                list.add(REST_SOUTH);
                list.add(REST_RIGHT_SOUTH);
                list.add(REST_LEFT_SOUTH);
                BOUNDING_BOX = BOUNDING_BOX_SOUTH;
                break;
            }
            case WEST: {
                list.add(SEAT_WEST);
                list.add(REST_WEST);
                list.add(REST_RIGHT_WEST);
                list.add(REST_LEFT_WEST);
                BOUNDING_BOX = BOUNDING_BOX_WEST;
                break;
            }
            default: {
                list.add(SEAT_NORTH);
                list.add(REST_NORTH);
                list.add(REST_RIGHT_NORTH);
                list.add(REST_LEFT_NORTH);
                BOUNDING_BOX = BOUNDING_BOX_NORTH;
            }
        }
        return list;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        List<AxisAlignedBB> list = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos));
        for (AxisAlignedBB box : list) {
            BlockhospitalSofaThirdWhite.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return !playerIn.func_70093_af() && SeatUtils.sitOnBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, 0.3);
    }

    public BlockhospitalSofaThirdWhite(Material materialIn, SoundType soundType, String blockName) {
        super(materialIn, soundType, blockName);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    static {
        BOUNDING_BOX_NORTH = new AxisAlignedBB(-1.0, 0.0, 0.0, 2.0, 1.2, 1.0);
        BOUNDING_BOX_EAST = CollisionUtils.rotateAABB(BOUNDING_BOX_NORTH, EnumFacing.EAST);
        BOUNDING_BOX_SOUTH = CollisionUtils.rotateAABB(BOUNDING_BOX_NORTH, EnumFacing.SOUTH);
        BOUNDING_BOX_WEST = CollisionUtils.rotateAABB(BOUNDING_BOX_NORTH, EnumFacing.WEST);
        SEAT_NORTH = new AxisAlignedBB(-1.0, 0.0, 0.0, 2.0, 0.5, 0.9);
        SEAT_EAST = CollisionUtils.rotateAABB(SEAT_NORTH, EnumFacing.EAST);
        SEAT_WEST = CollisionUtils.rotateAABB(SEAT_NORTH, EnumFacing.WEST);
        SEAT_SOUTH = CollisionUtils.rotateAABB(SEAT_NORTH, EnumFacing.SOUTH);
        REST_NORTH = new AxisAlignedBB(-0.8, 0.0, 0.0, 1.8, 1.15, 0.2);
        REST_EAST = CollisionUtils.rotateAABB(REST_NORTH, EnumFacing.EAST);
        REST_WEST = CollisionUtils.rotateAABB(REST_NORTH, EnumFacing.WEST);
        REST_SOUTH = CollisionUtils.rotateAABB(REST_NORTH, EnumFacing.SOUTH);
        REST_RIGHT_NORTH = new AxisAlignedBB(-1.1, 0.0, 0.0, -1.05, 0.85, 1.0);
        REST_RIGHT_EAST = CollisionUtils.rotateAABB(REST_RIGHT_NORTH, EnumFacing.EAST);
        REST_RIGHT_WEST = CollisionUtils.rotateAABB(REST_RIGHT_NORTH, EnumFacing.WEST);
        REST_RIGHT_SOUTH = CollisionUtils.rotateAABB(REST_RIGHT_NORTH, EnumFacing.SOUTH);
        REST_LEFT_NORTH = new AxisAlignedBB(1.95, 0.0, 0.0, 2.1, 0.85, 1.0);
        REST_LEFT_EAST = CollisionUtils.rotateAABB(REST_LEFT_NORTH, EnumFacing.EAST);
        REST_LEFT_WEST = CollisionUtils.rotateAABB(REST_LEFT_NORTH, EnumFacing.WEST);
        REST_LEFT_SOUTH = CollisionUtils.rotateAABB(REST_LEFT_NORTH, EnumFacing.SOUTH);
    }
}

