/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.furniture;

import com.google.common.collect.Lists;
import fr.minepiece.common.api.utils.CollisionUtils;
import fr.minepiece.common.blocks.BlockRotatable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRuins
extends BlockRotatable {
    public static AxisAlignedBB BOUNDING_BOX;
    public static AxisAlignedBB BOUNDING_BOX_NORTH;
    public static AxisAlignedBB BOUNDING_BOX_EAST;
    public static AxisAlignedBB BOUNDING_BOX_SOUTH;
    public static AxisAlignedBB BOUNDING_BOX_WEST;
    public static AxisAlignedBB SLAB_1_NORTH;
    public static AxisAlignedBB SLAB_1_EAST;
    public static AxisAlignedBB SLAB_1_SOUTH;
    public static AxisAlignedBB SLAB_1_WEST;
    public static AxisAlignedBB SLAB_2_NORTH;
    public static AxisAlignedBB SLAB_2_EAST;
    public static AxisAlignedBB SLAB_2_SOUTH;
    public static AxisAlignedBB SLAB_2_WEST;
    public static AxisAlignedBB SLAB_3_NORTH;
    public static AxisAlignedBB SLAB_3_EAST;
    public static AxisAlignedBB SLAB_3_SOUTH;
    public static AxisAlignedBB SLAB_3_WEST;
    public static AxisAlignedBB SLAB_4_NORTH;
    public static AxisAlignedBB SLAB_4_EAST;
    public static AxisAlignedBB SLAB_4_SOUTH;
    public static AxisAlignedBB SLAB_4_WEST;

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case EAST: {
                list.add(SLAB_1_EAST);
                list.add(SLAB_2_EAST);
                list.add(SLAB_3_EAST);
                list.add(SLAB_4_EAST);
                BOUNDING_BOX = BOUNDING_BOX_EAST;
                break;
            }
            case SOUTH: {
                list.add(SLAB_1_SOUTH);
                list.add(SLAB_2_SOUTH);
                list.add(SLAB_3_SOUTH);
                list.add(SLAB_4_SOUTH);
                BOUNDING_BOX = BOUNDING_BOX_SOUTH;
                break;
            }
            case WEST: {
                list.add(SLAB_1_WEST);
                list.add(SLAB_2_WEST);
                list.add(SLAB_3_WEST);
                list.add(SLAB_4_WEST);
                BOUNDING_BOX = BOUNDING_BOX_WEST;
                break;
            }
            default: {
                list.add(SLAB_1_NORTH);
                list.add(SLAB_2_NORTH);
                list.add(SLAB_3_NORTH);
                list.add(SLAB_4_NORTH);
                BOUNDING_BOX = BOUNDING_BOX_NORTH;
            }
        }
        return list;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        List<AxisAlignedBB> list = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos));
        for (AxisAlignedBB box : list) {
            BlockRuins.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public BlockRuins(Material materialIn, SoundType soundType, String blockName) {
        super(materialIn, soundType, blockName);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    static {
        BOUNDING_BOX_NORTH = new AxisAlignedBB(0.2, 0.0, 0.1, 1.3, 1.75, 0.9);
        BOUNDING_BOX_EAST = CollisionUtils.rotateAABB(BOUNDING_BOX_NORTH, EnumFacing.EAST);
        BOUNDING_BOX_SOUTH = CollisionUtils.rotateAABB(BOUNDING_BOX_NORTH, EnumFacing.SOUTH);
        BOUNDING_BOX_WEST = CollisionUtils.rotateAABB(BOUNDING_BOX_NORTH, EnumFacing.WEST);
        SLAB_1_NORTH = new AxisAlignedBB(0.35, 0.0, 0.25, 1.0, 0.5, 0.75);
        SLAB_1_EAST = CollisionUtils.rotateAABB(SLAB_1_NORTH, EnumFacing.EAST);
        SLAB_1_SOUTH = CollisionUtils.rotateAABB(SLAB_1_NORTH, EnumFacing.SOUTH);
        SLAB_1_WEST = CollisionUtils.rotateAABB(SLAB_1_NORTH, EnumFacing.WEST);
        SLAB_2_NORTH = new AxisAlignedBB(0.5, 0.5, 0.25, 1.15, 1.0, 0.75);
        SLAB_2_EAST = CollisionUtils.rotateAABB(SLAB_2_NORTH, EnumFacing.EAST);
        SLAB_2_SOUTH = CollisionUtils.rotateAABB(SLAB_2_NORTH, EnumFacing.SOUTH);
        SLAB_2_WEST = CollisionUtils.rotateAABB(SLAB_2_NORTH, EnumFacing.WEST);
        SLAB_3_NORTH = new AxisAlignedBB(0.65, 1.0, 0.25, 1.3, 1.5, 0.75);
        SLAB_3_EAST = CollisionUtils.rotateAABB(SLAB_3_NORTH, EnumFacing.EAST);
        SLAB_3_SOUTH = CollisionUtils.rotateAABB(SLAB_3_NORTH, EnumFacing.SOUTH);
        SLAB_3_WEST = CollisionUtils.rotateAABB(SLAB_3_NORTH, EnumFacing.WEST);
        SLAB_4_NORTH = new AxisAlignedBB(0.8, 1.5, 0.25, 1.45, 1.75, 0.75);
        SLAB_4_EAST = CollisionUtils.rotateAABB(SLAB_4_NORTH, EnumFacing.EAST);
        SLAB_4_SOUTH = CollisionUtils.rotateAABB(SLAB_4_NORTH, EnumFacing.SOUTH);
        SLAB_4_WEST = CollisionUtils.rotateAABB(SLAB_4_NORTH, EnumFacing.WEST);
    }
}

