/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.furniture;

import com.google.common.collect.Lists;
import fr.minepiece.common.api.utils.CollisionUtils;
import fr.minepiece.common.blocks.BlockRotatable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRestaurantBar
extends BlockRotatable {
    public static AxisAlignedBB BOUNDING_BOX;
    public static AxisAlignedBB BOUNDING_BOX_NORTH;
    public static AxisAlignedBB BOUNDING_BOX_EAST;
    public static AxisAlignedBB BOUNDING_BOX_SOUTH;
    public static AxisAlignedBB BOUNDING_BOX_WEST;
    public static AxisAlignedBB STORAGE_1_NORTH;
    public static AxisAlignedBB STORAGE_1_SOUTH;
    public static AxisAlignedBB STORAGE_1_EAST;
    public static AxisAlignedBB STORAGE_1_WEST;
    public static AxisAlignedBB STORAGE_2_NORTH;
    public static AxisAlignedBB STORAGE_2_SOUTH;
    public static AxisAlignedBB STORAGE_2_EAST;
    public static AxisAlignedBB STORAGE_2_WEST;
    public static AxisAlignedBB STORAGE_3_NORTH;
    public static AxisAlignedBB STORAGE_3_SOUTH;
    public static AxisAlignedBB STORAGE_3_EAST;
    public static AxisAlignedBB STORAGE_3_WEST;
    public static AxisAlignedBB BAR_NORTH;
    public static AxisAlignedBB BAR_SOUTH;
    public static AxisAlignedBB BAR_EAST;
    public static AxisAlignedBB BAR_WEST;
    public static AxisAlignedBB RIGHT_PILLAR_NORTH;
    public static AxisAlignedBB RIGHT_PILLAR_SOUTH;
    public static AxisAlignedBB RIGHT_PILLAR_EAST;
    public static AxisAlignedBB RIGHT_PILLAR_WEST;
    public static AxisAlignedBB LEFT_PILLAR_NORTH;
    public static AxisAlignedBB LEFT_PILLAR_SOUTH;
    public static AxisAlignedBB LEFT_PILLAR_EAST;
    public static AxisAlignedBB LEFT_PILLAR_WEST;
    public static AxisAlignedBB ROOF_NORTH;
    public static AxisAlignedBB ROOF_SOUTH;
    public static AxisAlignedBB ROOF_EAST;
    public static AxisAlignedBB ROOF_WEST;

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case EAST: {
                list.add(BAR_EAST);
                list.add(STORAGE_1_EAST);
                list.add(STORAGE_2_EAST);
                list.add(STORAGE_3_EAST);
                list.add(LEFT_PILLAR_EAST);
                list.add(RIGHT_PILLAR_EAST);
                list.add(ROOF_EAST);
                BOUNDING_BOX = BOUNDING_BOX_EAST;
                break;
            }
            case SOUTH: {
                list.add(BAR_SOUTH);
                list.add(STORAGE_1_SOUTH);
                list.add(STORAGE_2_SOUTH);
                list.add(STORAGE_3_SOUTH);
                list.add(LEFT_PILLAR_SOUTH);
                list.add(RIGHT_PILLAR_SOUTH);
                list.add(ROOF_SOUTH);
                BOUNDING_BOX = BOUNDING_BOX_SOUTH;
                break;
            }
            case WEST: {
                list.add(BAR_WEST);
                list.add(STORAGE_1_WEST);
                list.add(STORAGE_2_WEST);
                list.add(STORAGE_3_WEST);
                list.add(LEFT_PILLAR_WEST);
                list.add(RIGHT_PILLAR_WEST);
                list.add(ROOF_WEST);
                BOUNDING_BOX = BOUNDING_BOX_WEST;
                break;
            }
            default: {
                list.add(BAR_NORTH);
                list.add(STORAGE_1_NORTH);
                list.add(STORAGE_2_NORTH);
                list.add(STORAGE_3_NORTH);
                list.add(LEFT_PILLAR_NORTH);
                list.add(RIGHT_PILLAR_NORTH);
                list.add(ROOF_NORTH);
                BOUNDING_BOX = BOUNDING_BOX_NORTH;
            }
        }
        return list;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        List<AxisAlignedBB> list = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos));
        for (AxisAlignedBB box : list) {
            BlockRestaurantBar.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public BlockRestaurantBar(Material materialIn, SoundType soundType, String blockName) {
        super(materialIn, soundType, blockName);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    static {
        BOUNDING_BOX_NORTH = new AxisAlignedBB(-0.9, -1.0, -0.95, 1.9, 1.75, 0.0);
        BOUNDING_BOX_EAST = CollisionUtils.rotateAABB(BOUNDING_BOX_NORTH, EnumFacing.EAST);
        BOUNDING_BOX_SOUTH = CollisionUtils.rotateAABB(BOUNDING_BOX_NORTH, EnumFacing.SOUTH);
        BOUNDING_BOX_WEST = CollisionUtils.rotateAABB(BOUNDING_BOX_NORTH, EnumFacing.WEST);
        STORAGE_1_NORTH = new AxisAlignedBB(-0.9, -1.0, -0.95, 1.9, 0.0, 0.0);
        STORAGE_1_SOUTH = CollisionUtils.rotateAABB(STORAGE_1_NORTH, EnumFacing.SOUTH);
        STORAGE_1_EAST = CollisionUtils.rotateAABB(STORAGE_1_NORTH, EnumFacing.EAST);
        STORAGE_1_WEST = CollisionUtils.rotateAABB(STORAGE_1_NORTH, EnumFacing.WEST);
        STORAGE_2_NORTH = new AxisAlignedBB(-0.9, 0.0, -0.95, 1.9, 1.0, 0.0);
        STORAGE_2_SOUTH = CollisionUtils.rotateAABB(STORAGE_2_NORTH, EnumFacing.SOUTH);
        STORAGE_2_EAST = CollisionUtils.rotateAABB(STORAGE_2_NORTH, EnumFacing.EAST);
        STORAGE_2_WEST = CollisionUtils.rotateAABB(STORAGE_2_NORTH, EnumFacing.WEST);
        STORAGE_3_NORTH = new AxisAlignedBB(-0.9, 1.0, -0.95, 1.9, 1.75, 0.0);
        STORAGE_3_SOUTH = CollisionUtils.rotateAABB(STORAGE_3_NORTH, EnumFacing.SOUTH);
        STORAGE_3_EAST = CollisionUtils.rotateAABB(STORAGE_3_NORTH, EnumFacing.EAST);
        STORAGE_3_WEST = CollisionUtils.rotateAABB(STORAGE_3_NORTH, EnumFacing.WEST);
        BAR_NORTH = new AxisAlignedBB(-0.8, -1.0, 0.0, 1.8, 0.0, 0.9);
        BAR_SOUTH = CollisionUtils.rotateAABB(BAR_NORTH, EnumFacing.SOUTH);
        BAR_EAST = CollisionUtils.rotateAABB(BAR_NORTH, EnumFacing.EAST);
        BAR_WEST = CollisionUtils.rotateAABB(BAR_NORTH, EnumFacing.WEST);
        RIGHT_PILLAR_NORTH = new AxisAlignedBB(1.8, 0.0, -0.1, 2.0, 1.8, 0.1);
        RIGHT_PILLAR_SOUTH = CollisionUtils.rotateAABB(RIGHT_PILLAR_NORTH, EnumFacing.SOUTH);
        RIGHT_PILLAR_EAST = CollisionUtils.rotateAABB(RIGHT_PILLAR_NORTH, EnumFacing.EAST);
        RIGHT_PILLAR_WEST = CollisionUtils.rotateAABB(RIGHT_PILLAR_NORTH, EnumFacing.WEST);
        LEFT_PILLAR_NORTH = new AxisAlignedBB(-1.0, -1.0, -0.1, -0.8, 1.8, 0.1);
        LEFT_PILLAR_SOUTH = CollisionUtils.rotateAABB(LEFT_PILLAR_NORTH, EnumFacing.SOUTH);
        LEFT_PILLAR_EAST = CollisionUtils.rotateAABB(LEFT_PILLAR_NORTH, EnumFacing.EAST);
        LEFT_PILLAR_WEST = CollisionUtils.rotateAABB(LEFT_PILLAR_NORTH, EnumFacing.WEST);
        ROOF_NORTH = new AxisAlignedBB(-1.0, 1.8, -1.0, 1.0, 2.0, 0.5);
        ROOF_SOUTH = CollisionUtils.rotateAABB(ROOF_NORTH, EnumFacing.SOUTH);
        ROOF_EAST = CollisionUtils.rotateAABB(ROOF_NORTH, EnumFacing.EAST);
        ROOF_WEST = CollisionUtils.rotateAABB(ROOF_NORTH, EnumFacing.WEST);
    }
}

