/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.furniture;

import com.google.common.collect.Lists;
import fr.minepiece.common.api.utils.CollisionUtils;
import fr.minepiece.common.blocks.BlockRotatable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockHospitalShelfWithHandle
extends BlockRotatable {
    public static AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.85, 1.0);
    public static AxisAlignedBB CART_NORTH = new AxisAlignedBB(-0.1, 0.0, 0.1, 1.1, 0.85, 0.9);
    public static AxisAlignedBB CART_EAST = CollisionUtils.rotateAABB(CART_NORTH, EnumFacing.EAST);
    public static AxisAlignedBB CART_SOUTH = CollisionUtils.rotateAABB(CART_NORTH, EnumFacing.SOUTH);
    public static AxisAlignedBB CART_WEST = CollisionUtils.rotateAABB(CART_NORTH, EnumFacing.WEST);
    public static AxisAlignedBB HANDLES_RIGTH_NORTH = new AxisAlignedBB(-0.25, 0.9, 0.1, 0.0, 1.0, 0.9);
    public static AxisAlignedBB HANDLES_RIGHT_EAST = CollisionUtils.rotateAABB(HANDLES_RIGTH_NORTH, EnumFacing.EAST);
    public static AxisAlignedBB HANDLES_RIGHT_SOUTH = CollisionUtils.rotateAABB(HANDLES_RIGTH_NORTH, EnumFacing.SOUTH);
    public static AxisAlignedBB HANDLES_RIGHT_WEST = CollisionUtils.rotateAABB(HANDLES_RIGTH_NORTH, EnumFacing.WEST);
    public static AxisAlignedBB HANDLES_LEFT_NORTH = new AxisAlignedBB(1.0, 0.9, 0.1, 1.25, 1.0, 0.9);
    public static AxisAlignedBB HANDLES_LEFT_EAST = CollisionUtils.rotateAABB(HANDLES_LEFT_NORTH, EnumFacing.EAST);
    public static AxisAlignedBB HANDLES_LEFT_SOUTH = CollisionUtils.rotateAABB(HANDLES_LEFT_NORTH, EnumFacing.SOUTH);
    public static AxisAlignedBB HANDLES_LEFT_WEST = CollisionUtils.rotateAABB(HANDLES_LEFT_NORTH, EnumFacing.WEST);

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case EAST: {
                list.add(CART_EAST);
                list.add(HANDLES_RIGHT_EAST);
                list.add(HANDLES_LEFT_EAST);
                break;
            }
            case SOUTH: {
                list.add(CART_SOUTH);
                list.add(HANDLES_RIGHT_SOUTH);
                list.add(HANDLES_LEFT_SOUTH);
                break;
            }
            case WEST: {
                list.add(CART_WEST);
                list.add(HANDLES_RIGHT_WEST);
                list.add(HANDLES_LEFT_WEST);
                break;
            }
            default: {
                list.add(CART_NORTH);
                list.add(HANDLES_RIGTH_NORTH);
                list.add(HANDLES_LEFT_NORTH);
            }
        }
        return list;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        List<AxisAlignedBB> list = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos));
        for (AxisAlignedBB box : list) {
            BlockHospitalShelfWithHandle.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public BlockHospitalShelfWithHandle(Material materialIn, SoundType soundType, String blockName) {
        super(materialIn, soundType, blockName);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

