/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.furniture;

import com.google.common.collect.Lists;
import fr.minepiece.common.api.utils.CollisionUtils;
import fr.minepiece.common.blocks.BlockRotatable;
import fr.minepiece.common.blocks.Interactive;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCasinoChairBarRed
extends BlockRotatable
implements Interactive {
    public static AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.2, 0.0, 0.2, 0.8, 1.0, 0.8);
    public static AxisAlignedBB CHAIR_SEAT = new AxisAlignedBB(0.2, 0.8, 0.2, 0.8, 0.95, 0.8);
    public static AxisAlignedBB CHAIR_PILLAR = new AxisAlignedBB(0.45, 0.0, 0.45, 0.55, 0.8, 0.55);
    public static AxisAlignedBB CHAIR_BACKREST_NORTH = new AxisAlignedBB(0.2, 0.8, 0.15, 0.8, 1.25, 0.15);
    public static AxisAlignedBB CHAIR_BACKREST_EAST = CollisionUtils.rotateAABB(CHAIR_BACKREST_NORTH, EnumFacing.EAST);
    public static AxisAlignedBB CHAIR_BACKREST_SOUTH = CollisionUtils.rotateAABB(CHAIR_BACKREST_NORTH, EnumFacing.SOUTH);
    public static AxisAlignedBB CHAIR_BACKREST_WEST = CollisionUtils.rotateAABB(CHAIR_BACKREST_NORTH, EnumFacing.WEST);

    public BlockCasinoChairBarRed(Material materialIn, SoundType soundType, String blockName) {
        super(materialIn, soundType, blockName);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.trySeat(worldIn, pos, playerIn, 0.7);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case EAST: {
                list.add(CHAIR_BACKREST_EAST);
                break;
            }
            case SOUTH: {
                list.add(CHAIR_BACKREST_SOUTH);
                break;
            }
            case WEST: {
                list.add(CHAIR_BACKREST_WEST);
                break;
            }
            default: {
                list.add(CHAIR_BACKREST_NORTH);
            }
        }
        list.add(CHAIR_SEAT);
        list.add(CHAIR_PILLAR);
        return list;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        List<AxisAlignedBB> list = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos));
        for (AxisAlignedBB box : list) {
            BlockCasinoChairBarRed.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }
}

