/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.furniture;

import com.google.common.collect.Lists;
import fr.minepiece.common.api.utils.CollisionUtils;
import fr.minepiece.common.blocks.BlockRotatable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAnchor
extends BlockRotatable {
    public static AxisAlignedBB BOUNDING_BOX;
    public static AxisAlignedBB BOUNDING_BOX_NORTH;
    public static AxisAlignedBB BOUNDING_BOX_EAST;
    public static AxisAlignedBB BOUNDING_BOX_SOUTH;
    public static AxisAlignedBB BOUNDING_BOX_WEST;
    public static AxisAlignedBB ANCHOR_NORTH;
    public static AxisAlignedBB ANCHOR_EAST;
    public static AxisAlignedBB ANCHOR_SOUTH;
    public static AxisAlignedBB ANCHOR_WEST;

    private List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case EAST: {
                list.add(ANCHOR_EAST);
                BOUNDING_BOX = BOUNDING_BOX_EAST;
                break;
            }
            case SOUTH: {
                list.add(ANCHOR_SOUTH);
                BOUNDING_BOX = BOUNDING_BOX_SOUTH;
                break;
            }
            case WEST: {
                list.add(ANCHOR_WEST);
                BOUNDING_BOX = BOUNDING_BOX_WEST;
                break;
            }
            default: {
                list.add(ANCHOR_NORTH);
                BOUNDING_BOX = BOUNDING_BOX_NORTH;
            }
        }
        return list;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        List<AxisAlignedBB> list = this.getCollisionBoxList(this.func_176221_a(state, (IBlockAccess)worldIn, pos));
        for (AxisAlignedBB box : list) {
            BlockAnchor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public BlockAnchor(Material materialIn, SoundType soundType, String blockName) {
        super(materialIn, soundType, blockName);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    static {
        BOUNDING_BOX_NORTH = new AxisAlignedBB(0.0, 0.0, 0.4, 1.0, 1.4, 0.6);
        BOUNDING_BOX_EAST = CollisionUtils.rotateAABB(BOUNDING_BOX_NORTH, EnumFacing.EAST);
        BOUNDING_BOX_SOUTH = CollisionUtils.rotateAABB(BOUNDING_BOX_NORTH, EnumFacing.SOUTH);
        BOUNDING_BOX_WEST = CollisionUtils.rotateAABB(BOUNDING_BOX_NORTH, EnumFacing.WEST);
        ANCHOR_NORTH = new AxisAlignedBB(-0.1, 0.0, 0.4, 1.1, 1.5, 0.6);
        ANCHOR_EAST = CollisionUtils.rotateAABB(ANCHOR_NORTH, EnumFacing.EAST);
        ANCHOR_SOUTH = CollisionUtils.rotateAABB(ANCHOR_NORTH, EnumFacing.SOUTH);
        ANCHOR_WEST = CollisionUtils.rotateAABB(ANCHOR_NORTH, EnumFacing.WEST);
    }
}

