/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.crops;

import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.items.jobs.JobToolItem;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class AbstractCropBlock
extends BlockCrops {
    protected static final AxisAlignedBB[] CROP_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.05, 1.0)};
    protected final int jobXpAmount;
    protected final Class<? extends JobToolItem> requiredToolClass;
    protected final int dropAmount;
    protected final MinePieceJobs requiredJob;

    public AbstractCropBlock(String name, int jobXpAmount, Class<? extends JobToolItem> requiredToolClass, int dropAmount, MinePieceJobs requiredJob) {
        this.jobXpAmount = jobXpAmount;
        this.requiredToolClass = requiredToolClass;
        this.dropAmount = dropAmount;
        this.requiredJob = requiredJob;
        this.func_149663_c(name);
        this.setRegistryName(name);
    }

    public AbstractCropBlock(String name, int jobXpAmount, Class<? extends JobToolItem> requiredToolClass, MinePieceJobs requiredJob) {
        this(name, jobXpAmount, requiredToolClass, 3, requiredJob);
    }

    public AbstractCropBlock(String name, int jobXpAmount, Class<? extends JobToolItem> requiredToolClass, int dropAmount) {
        this(name, jobXpAmount, requiredToolClass, dropAmount, null);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return false;
        }
        ItemStack heldItem = playerIn.func_184586_b(hand);
        Item item = heldItem.func_77973_b();
        if (!this.requiredToolClass.isInstance(item)) {
            return false;
        }
        JobToolItem tool = (JobToolItem)item;
        IMinePieceData mpData = (IMinePieceData)playerIn.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (mpData == null) {
            return false;
        }
        if (this.requiredJob != null && mpData.getJob() != this.requiredJob) {
            playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Vous devez \u00eatre " + this.requiredJob.getName() + " pour r\u00e9colter cette plante !"));
            return false;
        }
        if (!tool.isUsableAtLevel(mpData.getJobLevel())) {
            playerIn.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Vous n'avez pas le niveau requis pour utiliser cet outil !"));
            return false;
        }
        if (this.func_185525_y(state)) {
            PlayerUtils.addJobXpToPlayer((EntityPlayerMP)playerIn, this.jobXpAmount + tool.getXpBonus());
            mpData.clientSync((EntityPlayerMP)playerIn);
            worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(this.func_149865_P(), this.dropAmount)));
            if (worldIn.field_73012_v.nextFloat() < this.getAdditionalSeedDropChance()) {
                worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(this.func_149866_i(), 1)));
            }
            heldItem.func_77972_a(1, (EntityLivingBase)playerIn);
            worldIn.func_175656_a(pos, this.func_185528_e(0));
            return true;
        }
        return false;
    }

    protected float getAdditionalSeedDropChance() {
        return 0.25f;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROP_AABB[(Integer)state.func_177229_b((IProperty)this.func_185524_e())];
    }
}

