/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.clusters;

import fr.minepiece.common.blocks.clusters.AbstractClusterBlock;
import fr.minepiece.common.utils.ClusterConfigManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;

public class SmallClusterBlock
extends AbstractClusterBlock {
    private static final List<AxisAlignedBB> DEFAULT_BOUNDING_BOXES = SmallClusterBlock.createDefaultBoundingBoxes();
    private Item dropItem;

    public SmallClusterBlock(Material material, SoundType soundType, String blockName, String oreType, int jobXpAmount, String mediumBlockName, Item dropItem) {
        super(material, soundType, blockName, oreType, jobXpAmount, false, null, mediumBlockName, DEFAULT_BOUNDING_BOXES);
        this.dropItem = dropItem;
    }

    public SmallClusterBlock(Material material, SoundType soundType, String blockName, String oreType, int jobXpAmount, String depletedBlockName, String mediumBlockName, Item dropItem) {
        super(material, soundType, blockName, oreType, jobXpAmount, false, depletedBlockName, mediumBlockName, DEFAULT_BOUNDING_BOXES);
        this.dropItem = dropItem;
    }

    private static List<AxisAlignedBB> createDefaultBoundingBoxes() {
        float[][] elements;
        ArrayList<AxisAlignedBB> boundingBoxes = new ArrayList<AxisAlignedBB>();
        for (float[] element : elements = new float[][]{{4.0f, 0.0f, 4.0f, 12.0f, 2.0f, 12.0f}, {6.0f, 1.5f, 8.25f, 10.0f, 4.5f, 14.25f}, {6.0f, 3.0f, 4.5f, 10.0f, 10.0f, 7.5f}, {3.25f, 2.25f, 6.75f, 8.25f, 9.25f, 10.75f}, {7.40224f, 2.76537f, 5.0f, 12.40224f, 11.76537f, 9.0f}}) {
            boundingBoxes.add(new AxisAlignedBB((double)element[0] / 16.0, (double)element[1] / 16.0, (double)element[2] / 16.0, (double)element[3] / 16.0, (double)element[4] / 16.0, (double)element[5] / 16.0));
        }
        return boundingBoxes;
    }

    public SmallClusterBlock setDropItem(Item item) {
        this.dropItem = item;
        return this;
    }

    @Override
    protected Item getHarvestDrop() {
        return this.dropItem;
    }

    @Override
    protected int getDropCount() {
        return ClusterConfigManager.getSmallDropCount();
    }
}

