/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.clusters;

import fr.minepiece.common.blocks.clusters.AbstractClusterBlock;
import fr.minepiece.common.utils.ClusterConfigManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;

public class MediumClusterBlock
extends AbstractClusterBlock {
    private static final List<AxisAlignedBB> DEFAULT_BOUNDING_BOXES = MediumClusterBlock.createDefaultBoundingBoxes();
    private Item dropItem;

    public MediumClusterBlock(Material material, SoundType soundType, String blockName, String oreType, int jobXpAmount, String smallBlockName, String bigBlockName, Item dropItem) {
        super(material, soundType, blockName, oreType, jobXpAmount, false, smallBlockName, bigBlockName, DEFAULT_BOUNDING_BOXES);
        this.dropItem = dropItem;
    }

    private static List<AxisAlignedBB> createDefaultBoundingBoxes() {
        float[][] elements;
        ArrayList<AxisAlignedBB> boundingBoxes = new ArrayList<AxisAlignedBB>();
        for (float[] element : elements = new float[][]{{1.0f, 0.0f, 1.0f, 15.0f, 2.0f, 15.0f}, {4.0f, 1.25f, 4.0f, 12.0f, 30.25f, 12.0f}, {8.5f, 1.75f, 10.25f, 12.5f, 4.75f, 18.25f}, {8.0f, 5.25f, 2.5f, 12.0f, 15.25f, 6.5f}, {3.04172f, 0.25f, 1.93925f, 8.04172f, 21.25f, 6.93925f}, {4.5f, 1.75f, 10.25f, 10.5f, 22.75f, 14.25f}, {11.19552f, 1.5f, 9.46927f, 14.19552f, 11.5f, 13.46927f}, {0.25f, 2.5f, 6.75f, 5.25f, 12.5f, 12.75f}, {8.57611f, 1.38949f, 3.0f, 17.57611f, 6.38949f, 9.0f}}) {
            boundingBoxes.add(new AxisAlignedBB((double)element[0] / 16.0, (double)element[1] / 16.0, (double)element[2] / 16.0, (double)element[3] / 16.0, (double)element[4] / 16.0, (double)element[5] / 16.0));
        }
        return boundingBoxes;
    }

    public MediumClusterBlock setDropItem(Item item) {
        this.dropItem = item;
        return this;
    }

    @Override
    protected Item getHarvestDrop() {
        return this.dropItem;
    }

    @Override
    protected int getDropCount() {
        int max;
        Random rand = new Random();
        int min = ClusterConfigManager.getMediumMinDropCount();
        if (min > (max = ClusterConfigManager.getMediumMaxDropCount())) {
            min = max;
        }
        return min + rand.nextInt(max - min + 1);
    }
}

