/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.clusters;

import fr.minepiece.common.blocks.clusters.AbstractClusterBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ClusterTileEntity
extends TileEntity
implements ITickable {
    private int regrowthTimer = -1;
    private String nextGrowthBlockName = "";
    private int tickCounter = 0;
    private boolean loggedInitialState = false;

    public void setRegrowthTime(int ticks) {
        this.regrowthTimer = ticks;
        this.func_70296_d();
    }

    public void setNextGrowthBlock(String blockName) {
        this.nextGrowthBlockName = blockName != null ? blockName : "";
        this.func_70296_d();
    }

    public void func_73660_a() {
        Block nextBlock;
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.loggedInitialState) {
            this.loggedInitialState = true;
            Block blockType = this.func_145838_q();
            String string = blockType != null ? blockType.func_149732_F() : "bloc inconnu";
        }
        ++this.tickCounter;
        if (this.regrowthTimer <= 0 || this.nextGrowthBlockName.isEmpty()) {
            return;
        }
        --this.regrowthTimer;
        if (this.regrowthTimer <= 0 && (nextBlock = Block.func_149684_b((String)("minepiece:" + this.nextGrowthBlockName))) != null) {
            NBTTagCompound oldData = new NBTTagCompound();
            this.func_189515_b(oldData);
            this.field_145850_b.func_180501_a(this.field_174879_c, nextBlock.func_176223_P(), 3);
            TileEntity newTe = this.field_145850_b.func_175625_s(this.field_174879_c);
            if (newTe instanceof ClusterTileEntity) {
                ClusterTileEntity clusterTE = (ClusterTileEntity)newTe;
                if (nextBlock instanceof AbstractClusterBlock) {
                    AbstractClusterBlock abstractNextBlock = (AbstractClusterBlock)nextBlock;
                    String nextGrowthBlock = abstractNextBlock.prevLevelBlockName;
                    if (nextGrowthBlock != null && !nextGrowthBlock.isEmpty()) {
                        int nextRegrowthTime = AbstractClusterBlock.getRegrowthTime(nextBlock);
                        clusterTE.setRegrowthTime(nextRegrowthTime);
                        clusterTE.setNextGrowthBlock(nextGrowthBlock);
                    }
                }
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("RegrowthTimer", this.regrowthTimer);
        compound.func_74778_a("NextGrowthBlock", this.nextGrowthBlockName);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.regrowthTimer = compound.func_74762_e("RegrowthTimer");
        this.nextGrowthBlockName = compound.func_74779_i("NextGrowthBlock");
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        boolean shouldRefresh = !(oldState.func_177230_c() instanceof AbstractClusterBlock) || !(newState.func_177230_c() instanceof AbstractClusterBlock);
        return shouldRefresh;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag.func_74768_a("RegrowthTimer", this.regrowthTimer);
        tag.func_74778_a("NextGrowthBlock", this.nextGrowthBlockName);
        return tag;
    }
}

