/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.clusters;

import fr.minepiece.common.blocks.clusters.AbstractClusterBlock;
import fr.minepiece.common.utils.ClusterConfigManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;

public class BigClusterBlock
extends AbstractClusterBlock {
    private static final List<AxisAlignedBB> DEFAULT_BOUNDING_BOXES = BigClusterBlock.createDefaultBoundingBoxes();
    private Item dropItem;

    public BigClusterBlock(Material material, SoundType soundType, String blockName, String oreType, int jobXpAmount, String mediumBlockName, Item dropItem) {
        super(material, soundType, blockName, oreType, jobXpAmount, false, mediumBlockName, null, DEFAULT_BOUNDING_BOXES);
        this.dropItem = dropItem;
    }

    private static List<AxisAlignedBB> createDefaultBoundingBoxes() {
        float[][] elements;
        ArrayList<AxisAlignedBB> boundingBoxes = new ArrayList<AxisAlignedBB>();
        for (float[] element : elements = new float[][]{{9.5f, -0.5f, 13.0f, 13.5f, 8.5f, 16.0f}, {8.0f, 3.25f, 2.5f, 12.0f, 15.25f, 6.5f}, {0.25f, 1.5f, 6.75f, 5.25f, 11.5f, 12.75f}, {5.57611f, 1.38949f, 6.0f, 18.57611f, 6.38949f, 12.0f}, {11.19552f, 1.5f, 9.46927f, 14.19552f, 15.5f, 13.46927f}, {1.5f, -2.25f, 11.75f, 7.5f, 13.75f, 15.75f}, {2.04172f, -0.75f, -0.06075f, 12.04172f, 21.25f, 8.93925f}, {4.0f, -0.75f, 4.0f, 15.0f, 32.0f, 14.0f}}) {
            boundingBoxes.add(new AxisAlignedBB((double)element[0] / 16.0, (double)element[1] / 16.0, (double)element[2] / 16.0, (double)element[3] / 16.0, (double)element[4] / 16.0, (double)element[5] / 16.0));
        }
        return boundingBoxes;
    }

    public BigClusterBlock setDropItem(Item item) {
        this.dropItem = item;
        return this;
    }

    @Override
    protected Item getHarvestDrop() {
        return this.dropItem;
    }

    @Override
    protected int getDropCount() {
        int max;
        Random rand = new Random();
        int min = ClusterConfigManager.getBigMinDropCount();
        if (min > (max = ClusterConfigManager.getBigMaxDropCount())) {
            min = max;
        }
        return min + rand.nextInt(max - min + 1);
    }
}

