/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.clusters;

import fr.minepiece.MinePiece;
import fr.minepiece.common.api.jobs.MinePieceJobs;
import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.blocks.BlockRotatable;
import fr.minepiece.common.blocks.Interactive;
import fr.minepiece.common.blocks.clusters.ClusterTileEntity;
import fr.minepiece.common.blocks.clusters.DepletedClusterBlock;
import fr.minepiece.common.blocks.clusters.MediumClusterBlock;
import fr.minepiece.common.blocks.clusters.SmallClusterBlock;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.utils.ClusterConfigManager;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractClusterBlock
extends BlockRotatable
implements Interactive {
    public static final int DEPLETED_REGROWTH_TIME_TEST = 100;
    public static final int SMALL_REGROWTH_TIME_TEST = 200;
    public static final int MEDIUM_REGROWTH_TIME_TEST = 400;
    public static final int DEPLETED_REGROWTH_TIME_PROD = 18000;
    public static final int SMALL_REGROWTH_TIME_PROD = 36000;
    public static final int MEDIUM_REGROWTH_TIME_PROD = 72000;
    protected final int jobXpAmount;
    protected final String oreType;
    protected final boolean isSmallest;
    protected final String nextLevelBlockName;
    protected final String prevLevelBlockName;
    protected final List<AxisAlignedBB> boundingBoxes;

    public AbstractClusterBlock(Material material, SoundType soundType, String blockName, String oreType, int jobXpAmount, boolean isSmallest, String nextLevelBlockName, String prevLevelBlockName, List<AxisAlignedBB> boundingBoxes) {
        super(material, soundType, blockName);
        this.oreType = oreType;
        this.jobXpAmount = jobXpAmount;
        this.isSmallest = isSmallest;
        this.nextLevelBlockName = nextLevelBlockName;
        this.prevLevelBlockName = prevLevelBlockName;
        this.boundingBoxes = boundingBoxes;
        this.func_149647_a(MinePiece.BLOCKS);
    }

    protected abstract Item getHarvestDrop();

    protected abstract int getDropCount();

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        for (AxisAlignedBB box : this.boundingBoxes) {
            AbstractClusterBlock.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)box);
        }
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (AxisAlignedBB axisalignedbb : this.boundingBoxes) {
            double d0;
            RayTraceResult raytraceresult = this.func_185503_a(pos, start, end, axisalignedbb);
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.boundingBoxes.get(0);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        if (this.isSmallest) {
            return -1.0f;
        }
        return 3.0f;
    }

    private boolean isIronPickaxe(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == Items.field_151035_b;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (worldIn.field_72995_K || this.isSmallest) {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
            return;
        }
        ItemStack heldItem = player.func_184614_ca();
        if (!this.isIronPickaxe(heldItem)) {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
            return;
        }
        IMinePieceData mpData = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        if (player instanceof EntityPlayerMP && mpData != null && mpData.getJob() == MinePieceJobs.BLACKSMITH) {
            PlayerUtils.addJobXpToPlayer((EntityPlayerMP)player, this.jobXpAmount);
            mpData.clientSync((EntityPlayerMP)player);
        }
        heldItem.func_77972_a(1, (EntityLivingBase)player);
        Item dropItem = this.getHarvestDrop();
        int dropCount = this.getDropCount();
        if (dropItem != null && dropCount > 0) {
            ItemStack itemStack = new ItemStack(dropItem, dropCount);
            worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemStack));
        }
        if (this.nextLevelBlockName != null && !this.nextLevelBlockName.isEmpty()) {
            Block nextLevelBlock = AbstractClusterBlock.getBlockFromName(this.nextLevelBlockName);
            if (nextLevelBlock != null) {
                TileEntity oldTE = worldIn.func_175625_s(pos);
                ClusterTileEntity clusterTE = null;
                worldIn.func_180501_a(pos, nextLevelBlock.func_176223_P(), 3);
                TileEntity newTE = worldIn.func_175625_s(pos);
                if (newTE instanceof ClusterTileEntity) {
                    clusterTE = (ClusterTileEntity)newTE;
                } else {
                    clusterTE = new ClusterTileEntity();
                    worldIn.func_175690_a(pos, (TileEntity)clusterTE);
                }
                if (nextLevelBlock instanceof AbstractClusterBlock) {
                    AbstractClusterBlock abstractNextBlock = (AbstractClusterBlock)nextLevelBlock;
                    String growthBlockName = abstractNextBlock.prevLevelBlockName;
                    if (growthBlockName != null && !growthBlockName.isEmpty()) {
                        int regrowthTime = AbstractClusterBlock.getRegrowthTime(nextLevelBlock);
                        clusterTE.setRegrowthTime(regrowthTime);
                        clusterTE.setNextGrowthBlock(growthBlockName);
                        worldIn.func_184138_a(pos, worldIn.func_180495_p(pos), worldIn.func_180495_p(pos), 3);
                        worldIn.func_175646_b(pos, (TileEntity)clusterTE);
                    }
                }
            }
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    protected void scheduleRegrowth(World world, BlockPos pos, Block currentBlock) {
        ClusterTileEntity clusterTE;
        TileEntity existingTE = world.func_175625_s(pos);
        if (existingTE != null && !(existingTE instanceof ClusterTileEntity)) {
            world.func_175713_t(pos);
            existingTE = null;
        }
        if (existingTE instanceof ClusterTileEntity) {
            clusterTE = (ClusterTileEntity)existingTE;
        } else {
            clusterTE = new ClusterTileEntity();
            world.func_175690_a(pos, (TileEntity)clusterTE);
        }
        int regrowthTime = AbstractClusterBlock.getRegrowthTime(currentBlock);
        clusterTE.setRegrowthTime(regrowthTime);
        if (currentBlock instanceof AbstractClusterBlock) {
            AbstractClusterBlock aCluster = (AbstractClusterBlock)currentBlock;
            String nextBlockName = aCluster.prevLevelBlockName;
            clusterTE.setNextGrowthBlock(nextBlockName);
        }
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
        world.func_175646_b(pos, (TileEntity)clusterTE);
    }

    public void forceStartRegrowth(World world, BlockPos pos) {
        ClusterTileEntity clusterTE;
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ClusterTileEntity) {
            clusterTE = (ClusterTileEntity)te;
        } else {
            clusterTE = new ClusterTileEntity();
            world.func_175690_a(pos, (TileEntity)clusterTE);
        }
        int regrowthTime = AbstractClusterBlock.getRegrowthTime(this);
        clusterTE.setRegrowthTime(regrowthTime);
        if (this.prevLevelBlockName != null && !this.prevLevelBlockName.isEmpty()) {
            clusterTE.setNextGrowthBlock(this.prevLevelBlockName);
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
            world.func_175646_b(pos, (TileEntity)clusterTE);
        }
    }

    public static Block getBlockFromName(String name) {
        return Block.func_149684_b((String)("minepiece:" + name));
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        if (this.isSmallest) {
            return false;
        }
        ItemStack heldItem = player.func_184614_ca();
        return this.isIronPickaxe(heldItem);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new ClusterTileEntity();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            this.forceStartRegrowth(worldIn, pos);
        }
    }

    public static int getRegrowthTime(Block blockType) {
        if (blockType instanceof DepletedClusterBlock) {
            return ClusterConfigManager.getDepletedRegrowthTime();
        }
        if (blockType instanceof SmallClusterBlock) {
            return ClusterConfigManager.getSmallRegrowthTime();
        }
        if (blockType instanceof MediumClusterBlock) {
            return ClusterConfigManager.getMediumRegrowthTime();
        }
        return ClusterConfigManager.getSmallRegrowthTime();
    }
}

