/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.canons;

import fr.minepiece.common.blocks.canons.BlockCannon;
import fr.minepiece.common.blocks.canons.CannonLength;
import fr.minepiece.common.blocks.canons.CannonMaterial;
import fr.minepiece.common.entity.projectile.EntityCannonBall;
import fr.minepiece.common.init.ModBlocks;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class TileEntityCannon
extends TileEntity
implements IAnimatable,
ITickable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private CannonMaterial material = CannonMaterial.STEEL;
    private CannonLength length = CannonLength.SMALL;
    @Nullable
    private UUID controllingPlayerUUID = null;
    private float cannonYaw = 0.0f;
    private float cannonPitch = 0.0f;
    private boolean needsSync = false;
    private boolean justActedUpon = false;
    private boolean isShooting = false;
    private int shootAnimationTicks = 0;
    private static final int SHOOT_ANIMATION_LENGTH = 30;
    private boolean isFiringSequenceActive = false;
    private int shotDelayTicks = -1;
    private static final int SHOT_DELAY = 13;
    private int cooldownTicks = 0;
    private static final int MAX_COOLDOWN = 40;
    private boolean hasGunpowder = false;
    private boolean hasCannonball = false;

    private <E extends TileEntity> PlayState predicate(AnimationEvent<E> event) {
        if (this.isShooting) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.Canon_long.shoot", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public IBlockState getCannonBlockState() {
        if (this.field_145850_b != null && this.field_174879_c != null) {
            return this.field_145850_b.func_180495_p(this.field_174879_c);
        }
        return ModBlocks.CANNON.func_176223_P();
    }

    @Nullable
    public EntityPlayer getControllingPlayer(World world) {
        if (world == null || this.controllingPlayerUUID == null) {
            return null;
        }
        return world.func_152378_a(this.controllingPlayerUUID);
    }

    public void setControllingPlayer(@Nullable UUID playerUUID) {
        if (this.controllingPlayerUUID != playerUUID) {
            this.controllingPlayerUUID = playerUUID;
            this.needsSync = true;
            this.func_70296_d();
        }
    }

    public void triggerShootAnimation() {
        if (!this.isShooting) {
            this.isShooting = true;
            this.shootAnimationTicks = 30;
            this.needsSync = true;
            this.func_70296_d();
        }
    }

    public boolean triggerFireSequence(@Nullable EntityPlayer controller) {
        if (this.field_145850_b.field_72995_K || this.cooldownTicks > 0 || this.isFiringSequenceActive || !this.hasGunpowder || !this.hasCannonball) {
            return false;
        }
        this.isFiringSequenceActive = true;
        this.shotDelayTicks = 13;
        this.cooldownTicks = 40;
        this.isShooting = true;
        this.shootAnimationTicks = 30;
        this.needsSync = true;
        this.setHasCannonball(false);
        this.setHasGunpowder(false);
        this.func_70296_d();
        return true;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.justActedUpon = false;
            boolean controllerStillValid = false;
            if (this.controllingPlayerUUID != null) {
                EntityPlayer controller = this.getControllingPlayer(this.field_145850_b);
                if (controller != null && !controller.field_70128_L && controller.func_174818_b(this.func_174877_v()) < 100.0) {
                    if (controller.func_70093_af()) {
                        this.setControllingPlayer(null);
                    } else {
                        controllerStillValid = true;
                        float targetYaw = controller.field_70177_z;
                        float targetPitch = controller.field_70125_A;
                        IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
                        EnumFacing facing = EnumFacing.NORTH;
                        if (blockState.func_177230_c() instanceof BlockCannon && blockState.func_177227_a().contains(BlockCannon.FACING)) {
                            facing = (EnumFacing)blockState.func_177229_b((IProperty)BlockCannon.FACING);
                        }
                        float blockAngleOffset = facing.func_176734_d().func_185119_l();
                        targetPitch = MathHelper.func_76131_a((float)targetPitch, (float)-30.0f, (float)45.0f);
                        targetYaw = MathHelper.func_76142_g((float)(controller.field_70177_z - blockAngleOffset));
                        if (Math.abs((targetYaw = MathHelper.func_76131_a((float)targetYaw, (float)-5.0f, (float)5.0f)) - this.cannonYaw) > 0.1f || Math.abs(targetPitch - this.cannonPitch) > 0.1f) {
                            this.cannonYaw = targetYaw;
                            this.cannonPitch = targetPitch;
                            this.needsSync = true;
                        }
                    }
                }
                if (!controllerStillValid) {
                    this.setControllingPlayer(null);
                }
            }
            boolean needsSave = false;
            if (this.cooldownTicks > 0) {
                --this.cooldownTicks;
                this.func_70296_d();
            }
            if (this.isFiringSequenceActive) {
                --this.shotDelayTicks;
                if (this.shotDelayTicks <= 0) {
                    EntityPlayer controller = this.getControllingPlayer(this.field_145850_b);
                    this.spawnCannonball(controller);
                    this.isFiringSequenceActive = false;
                    this.shotDelayTicks = -1;
                }
                needsSave = true;
            }
            if (this.isShooting) {
                --this.shootAnimationTicks;
                if (this.shootAnimationTicks <= 0) {
                    this.isShooting = false;
                    this.needsSync = true;
                }
                needsSave = true;
            }
            if (this.needsSync) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                this.needsSync = false;
            }
            if (needsSave) {
                this.func_70296_d();
            }
        } else {
            this.justActedUpon = false;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74776_a("CannonYaw", this.cannonYaw);
        compound.func_74776_a("CannonPitch", this.cannonPitch);
        if (this.controllingPlayerUUID != null) {
            compound.func_186854_a("ControllerUUID", this.controllingPlayerUUID);
        }
        compound.func_74757_a("IsShooting", this.isShooting);
        compound.func_74768_a("ShootTicks", this.shootAnimationTicks);
        compound.func_74768_a("Cooldown", this.cooldownTicks);
        compound.func_74778_a("CannonMaterial", this.material == null ? CannonMaterial.STEEL.func_176610_l() : this.material.func_176610_l());
        compound.func_74778_a("CannonLength", this.length == null ? CannonLength.SMALL.func_176610_l() : this.length.func_176610_l());
        compound.func_74757_a("HasGunpowder", this.hasGunpowder);
        compound.func_74757_a("HasCannonball", this.hasCannonball);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.cannonYaw = compound.func_74760_g("CannonYaw");
        this.cannonPitch = compound.func_74760_g("CannonPitch");
        this.controllingPlayerUUID = compound.func_186855_b("ControllerUUID") ? compound.func_186857_a("ControllerUUID") : null;
        this.isShooting = compound.func_74767_n("IsShooting");
        this.shootAnimationTicks = compound.func_74762_e("ShootTicks");
        this.cooldownTicks = compound.func_74762_e("Cooldown");
        this.material = CannonMaterial.fromName(compound.func_74779_i("CannonMaterial"));
        this.length = CannonLength.fromName(compound.func_74779_i("CannonLength"));
        this.hasGunpowder = compound.func_74767_n("HasGunpowder");
        this.hasCannonball = compound.func_74767_n("HasCannonball");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
        this.justActedUpon = true;
    }

    private void spawnCannonball(@Nullable EntityPlayer controller) {
        IBlockState blockState = this.getCannonBlockState();
        CannonLength length = this.getCannonLength();
        EnumFacing facing = EnumFacing.NORTH;
        if (blockState.func_177230_c() instanceof BlockCannon && blockState.func_177227_a().contains(BlockCannon.FACING)) {
            facing = (EnumFacing)blockState.func_177229_b((IProperty)BlockCannon.FACING);
        }
        float blockAngleOffset = facing.func_176734_d().func_185119_l();
        float effectiveYaw = this.cannonYaw + blockAngleOffset;
        float yawRad = effectiveYaw * (float)Math.PI / 180.0f;
        float pitchRad = this.cannonPitch * (float)Math.PI / 180.0f;
        float fwdX = -MathHelper.func_76126_a((float)yawRad) * MathHelper.func_76134_b((float)pitchRad);
        float fwdY = -MathHelper.func_76126_a((float)pitchRad);
        float fwdZ = MathHelper.func_76134_b((float)yawRad) * MathHelper.func_76134_b((float)pitchRad);
        Vec3d forwardVector = new Vec3d((double)fwdX, (double)fwdY, (double)fwdZ).func_72432_b();
        double spawnOffsetDist = 1.5;
        Vec3d cannonCenter = new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.8, (double)this.field_174879_c.func_177952_p() + 0.5);
        Vec3d spawnPos = cannonCenter.func_178787_e(forwardVector.func_186678_a(spawnOffsetDist));
        float speed = length.getRangeModifier() * this.material.getRangeModifier();
        float inaccuracy = 0.0f;
        EntityCannonBall cannonball = new EntityCannonBall(this.material, length, this.field_145850_b, spawnPos.field_72450_a, spawnPos.field_72448_b, spawnPos.field_72449_c);
        if (controller != null) {
            cannonball.setThrower((EntityLivingBase)controller);
        }
        cannonball.func_70186_c(forwardVector.field_72450_a, forwardVector.field_72448_b, forwardVector.field_72449_c, speed, inaccuracy);
        this.field_145850_b.func_72838_d((Entity)cannonball);
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 2.0f, 1.0f / (this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f));
        if (this.field_145850_b instanceof WorldServer) {
            ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.LAVA, spawnPos.field_72450_a, spawnPos.field_72448_b, spawnPos.field_72449_c, 15, 0.2, 0.2, 0.2, 0.0, new int[0]);
            ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.SMOKE_LARGE, spawnPos.field_72450_a, spawnPos.field_72448_b, spawnPos.field_72449_c, 10, 0.3, 0.3, 0.3, 0.0, new int[0]);
        }
    }

    public void setHasGunpowder(boolean hasGunpowder) {
        if (this.hasGunpowder != hasGunpowder) {
            this.hasGunpowder = hasGunpowder;
            this.needsSync = true;
            this.func_70296_d();
        }
    }

    public void setHasCannonball(boolean hasCannonball) {
        if (this.hasCannonball != hasCannonball) {
            this.hasCannonball = hasCannonball;
            this.needsSync = true;
            this.func_70296_d();
        }
    }

    public boolean hasGunpowder() {
        return this.hasGunpowder;
    }

    public boolean hasCannonball() {
        return this.hasCannonball;
    }

    public CannonMaterial getCannonMaterial() {
        return this.material;
    }

    public CannonLength getCannonLength() {
        return this.length;
    }

    public void setMaterial(CannonMaterial material) {
        this.material = material;
    }

    public void setLength(CannonLength length) {
        this.length = length;
    }

    public boolean isOnCooldown() {
        return this.cooldownTicks > 0;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public float getCannonYaw() {
        return this.cannonYaw;
    }

    public float getCannonPitch() {
        return this.cannonPitch;
    }

    public boolean isControlled() {
        return this.controllingPlayerUUID != null;
    }

    public boolean isController(UUID uuid) {
        return this.controllingPlayerUUID != null && this.controllingPlayerUUID.equals(uuid);
    }

    public boolean isControlledBySomeoneOrActedUpon() {
        return this.isControlled() || this.justActedUpon;
    }
}

