/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.canons;

import fr.minepiece.common.blocks.canons.CannonLength;
import fr.minepiece.common.blocks.canons.CannonMaterial;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class ItemBlockCannon
extends ItemBlock
implements IAnimatable {
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public ItemBlockCannon(Block block) {
        super(block);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (CannonMaterial material : CannonMaterial.values()) {
                for (CannonLength length : CannonLength.values()) {
                    ItemStack stack = new ItemStack((Item)this);
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74778_a("material", material.func_176610_l());
                    tag.func_74778_a("length", length.func_176610_l());
                    stack.func_77982_d(tag);
                    items.add((Object)stack);
                }
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            String material = tag.func_74779_i("material");
            String length = tag.func_74779_i("length");
            return this.func_77658_a() + "." + material + "_" + length;
        }
        return super.func_77667_c(stack);
    }

    public CannonMaterial getCannonMaterial(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            String material = tag.func_74779_i("material");
            return CannonMaterial.fromName(material);
        }
        return CannonMaterial.STONE;
    }

    public CannonLength getCannonLength(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            String length = tag.func_74779_i("length");
            return CannonLength.fromName(length);
        }
        return CannonLength.SMALL;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.STOP;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

