/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.common.blocks.canons;

import fr.minepiece.MinePiece;
import fr.minepiece.common.blocks.BlockMinePiece;
import fr.minepiece.common.blocks.canons.CannonLength;
import fr.minepiece.common.blocks.canons.CannonMaterial;
import fr.minepiece.common.blocks.canons.ItemBlockCannon;
import fr.minepiece.common.blocks.canons.TileEntityCannon;
import fr.minepiece.common.init.ModItems;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCannon
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<CannonMaterial> MATERIAL_PROP = PropertyEnum.func_177709_a((String)"material", CannonMaterial.class);
    public static final PropertyEnum<CannonLength> LENGTH_PROP = PropertyEnum.func_177709_a((String)"length", CannonLength.class);

    public BlockCannon(String name) {
        super(Material.field_151573_f);
        BlockMinePiece.setBlockName((Block)this, name);
        this.func_149711_c(3.0f);
        this.func_149647_a(MinePiece.WEAPONS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(MATERIAL_PROP, (Comparable)((Object)CannonMaterial.STEEL)).func_177226_a(LENGTH_PROP, (Comparable)((Object)CannonLength.SMALL)));
    }

    public String func_149739_a() {
        return super.func_149739_a();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCannon();
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCannon();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof TileEntityCannon) {
            boolean emptyMainHand;
            TileEntityCannon cannonTE = (TileEntityCannon)te;
            UUID playerUUID = playerIn.func_110124_au();
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (heldItem.func_77973_b() == Items.field_151033_d) {
                if (cannonTE.isOnCooldown()) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Cannon is cooling down!"), true);
                    return true;
                }
                if (cannonTE.hasGunpowder() && cannonTE.hasCannonball()) {
                    boolean sequenceStarted = cannonTE.triggerFireSequence(playerIn);
                    if (sequenceStarted) {
                        worldIn.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f);
                        worldIn.func_184133_a(null, pos, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        if (!playerIn.field_71075_bZ.field_75098_d) {
                            heldItem.func_77972_a(1, (EntityLivingBase)playerIn);
                        }
                        playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Cannon Firing!"), true);
                    } else {
                        playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Cannot fire cannon now."), true);
                    }
                } else {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Cannon not fully loaded! Needs Gunpowder and Cannonball."), true);
                }
                return true;
            }
            if (heldItem.func_77973_b() == ModItems.SAC_POUDRE) {
                System.out.println("loading gunpowder");
                if (!cannonTE.hasGunpowder()) {
                    cannonTE.setHasGunpowder(true);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.8f, 0.8f);
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        heldItem.func_77972_a(1, (EntityLivingBase)playerIn);
                    }
                    playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Gunpowder loaded."), true);
                } else {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Gunpowder already loaded."), true);
                }
                return true;
            }
            if (heldItem.func_77973_b() == ModItems.BOULET_CANON_PIERRE) {
                System.out.println("loading cannonball");
                if (cannonTE.hasGunpowder()) {
                    if (!cannonTE.hasCannonball()) {
                        cannonTE.setHasCannonball(true);
                        worldIn.func_184133_a(null, pos, SoundEvents.field_187725_r, SoundCategory.BLOCKS, 1.0f, 0.9f);
                        if (!playerIn.field_71075_bZ.field_75098_d) {
                            heldItem.func_190918_g(1);
                        }
                        playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Cannonball loaded."), true);
                    } else {
                        playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "Cannonball already loaded."), true);
                    }
                } else {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "Load gunpowder first!"), true);
                }
                return true;
            }
            if (cannonTE.isControlled()) {
                if (cannonTE.isController(playerUUID)) {
                    if (playerIn.func_70093_af()) {
                        cannonTE.setControllingPlayer(null);
                        playerIn.func_146105_b((ITextComponent)new TextComponentString("Stopped controlling cannon."), true);
                        return true;
                    }
                    return true;
                }
                EntityPlayer currentController = cannonTE.getControllingPlayer(worldIn);
                String controllerName = currentController != null ? currentController.func_70005_c_() : "Someone";
                playerIn.func_146105_b((ITextComponent)new TextComponentString("Cannon is already controlled by " + controllerName + "."), true);
                return true;
            }
            boolean bl = emptyMainHand = hand == EnumHand.OFF_HAND && (playerIn.func_184614_ca().func_77973_b() == ModItems.BOULET_CANON_PIERRE || playerIn.func_184614_ca().func_77973_b() == ModItems.SAC_POUDRE || playerIn.func_184614_ca().func_77973_b() == Items.field_151033_d);
            if (playerIn.func_70093_af() || emptyMainHand) {
                return false;
            }
            cannonTE.setControllingPlayer(playerUUID);
            playerIn.func_146105_b((ITextComponent)new TextComponentString("Controlling cannon! Sneak to dismount."), true);
            return true;
        }
        te = worldIn.func_175625_s(pos);
        return te instanceof TileEntityCannon && ((TileEntityCannon)te).isControlledBySomeoneOrActedUpon();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemBlockCannon itemBlock = (ItemBlockCannon)Item.func_150898_a((Block)this);
        ItemStack itemStack = new ItemStack((Item)itemBlock, 1, this.func_180651_a(state));
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74778_a("material", ((CannonMaterial)((Object)state.func_177229_b(MATERIAL_PROP))).func_176610_l());
        tagCompound.func_74778_a("length", ((CannonLength)((Object)state.func_177229_b(LENGTH_PROP))).func_176610_l());
        itemStack.func_77982_d(tagCompound);
        drops.add((Object)itemStack);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof TileEntityCannon) {
            ((TileEntityCannon)te).setControllingPlayer(null);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        CannonMaterial material = CannonMaterial.STEEL;
        CannonLength length = CannonLength.SMALL;
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            material = CannonMaterial.fromName(tag.func_74779_i("material"));
            length = CannonLength.fromName(tag.func_74779_i("length"));
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a(MATERIAL_PROP, (Comparable)((Object)material)).func_177226_a(LENGTH_PROP, (Comparable)((Object)length)), 2);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCannon) {
            TileEntityCannon cannonTE = (TileEntityCannon)tileEntity;
            cannonTE.setMaterial(material);
            cannonTE.setLength(length);
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        ArrayList<ItemStack> variants = new ArrayList<ItemStack>();
        for (CannonMaterial material : CannonMaterial.values()) {
            for (CannonLength length : CannonLength.values()) {
                ItemStack stack = new ItemStack((Block)this);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("material", material.func_176610_l());
                tag.func_74778_a("length", length.func_176610_l());
                stack.func_77982_d(tag);
                variants.add(stack);
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, MATERIAL_PROP, LENGTH_PROP});
    }
}

